/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.HistoryCacheBaseKey;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.util.containers.SLRUMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryCache {
    private final Object myLock = new Object();
    private final SLRUMap<HistoryCacheBaseKey, CachedHistory> myHistoryCache;
    private final SLRUMap<HistoryCacheWithRevisionKey, Object> myAnnotationCache;

    public VcsHistoryCache() {
        boolean preloadEnabled = Registry.is((String)"vcs.annotations.preload");
        this.myHistoryCache = new SLRUMap(preloadEnabled ? 50 : 10, preloadEnabled ? 50 : 10);
        this.myAnnotationCache = new SLRUMap(preloadEnabled ? 50 : 10, preloadEnabled ? 50 : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Serializable, T extends VcsAbstractHistorySession> void put(FilePath filePath2, @Nullable FilePath correctedPath, VcsKey vcsKey, T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myHistoryCache.put((Object)new HistoryCacheBaseKey(filePath2, vcsKey), (Object)new CachedHistory(correctedPath != null ? correctedPath : filePath2, session.getRevisionList(), session.getCurrentRevisionNumber(), factory.getAddinionallyCachedData(session), isFull));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editCached(FilePath filePath2, VcsKey vcsKey, Consumer<List<VcsFileRevision>> consumer) {
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory != null) {
                consumer.consume(cachedHistory.getRevisions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getFull(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null || !cachedHistory.isIsFull()) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getMaybePartial(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        if (factory == null) {
            VcsHistoryCache.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myHistoryCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                if (((HistoryCacheBaseKey)next.getKey()).getFilePath().isNonLocal()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number, @NotNull Object vcsAnnotation) {
        if (filePath2 == null) {
            VcsHistoryCache.$$$reportNull$$$0(3);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(4);
        }
        if (number == null) {
            VcsHistoryCache.$$$reportNull$$$0(5);
        }
        if (vcsAnnotation == null) {
            VcsHistoryCache.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myAnnotationCache.put((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number), vcsAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number) {
        if (filePath2 == null) {
            VcsHistoryCache.$$$reportNull$$$0(7);
        }
        if (vcsKey == null) {
            VcsHistoryCache.$$$reportNull$$$0(8);
        }
        if (number == null) {
            VcsHistoryCache.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myAnnotationCache.get((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsAnnotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsHistoryCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFull";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMaybePartial";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CachedHistory {
        private final FilePath myPath;
        private final List<VcsFileRevision> myRevisions;
        private final VcsRevisionNumber myCurrentRevision;
        private final Object myCustomData;
        private final boolean myIsFull;

        public CachedHistory(FilePath path2, List<VcsFileRevision> revisions, VcsRevisionNumber currentRevision, Object customData, boolean isFull) {
            this.myPath = path2;
            this.myRevisions = revisions;
            this.myCurrentRevision = currentRevision;
            this.myCustomData = customData;
            this.myIsFull = isFull;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public List<VcsFileRevision> getRevisions() {
            return this.myRevisions;
        }

        public VcsRevisionNumber getCurrentRevision() {
            return this.myCurrentRevision;
        }

        public Object getCustomData() {
            return this.myCustomData;
        }

        public boolean isIsFull() {
            return this.myIsFull;
        }
    }
}

