/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.MultiColumnListModel;
import javax.swing.ListModel;

class FixedRowsModel
extends MultiColumnListModel {
    private final int myMaxRows;

    public FixedRowsModel(ListModel model, int rows) {
        super(model);
        this.myMaxRows = rows;
    }

    @Override
    public int getRowCount() {
        return Math.min(this.myMaxRows, this.getSize());
    }

    @Override
    public int getColumnCount() {
        int rows = this.getRowCount();
        return rows == 0 ? 0 : this.getSize() / rows + 1;
    }

    @Override
    public int toListIndex(int row, int column) {
        int rows = this.getRowCount();
        return rows == 0 ? -1 : column * rows + row;
    }

    @Override
    public int getColumn(int listIndex) {
        return listIndex / this.myMaxRows;
    }

    @Override
    public int getRow(int listIndex) {
        return listIndex % this.myMaxRows;
    }
}

