/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.ui.TabbedPaneImpl;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDiffPanel;
import git4idea.ui.branch.GitCompareBranchesLogPanel;
import git4idea.util.GitCommitCompareInfo;
import icons.VcsLogIcons;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitCompareBranchesDialog {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel myLogPanel;
    @NotNull
    private final TabbedPaneImpl myTabbedPane;
    @NotNull
    private final String myTitle;
    @NotNull
    private final WindowWrapper.Mode myMode;
    private WindowWrapper myWrapper;

    public GitCompareBranchesDialog(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo) {
        if (project == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(1);
        }
        if (currentBranchName == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(2);
        }
        if (compareInfo == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(3);
        }
        if (initialRepo == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(4);
        }
        this(project, branchName, currentBranchName, compareInfo, initialRepo, false);
    }

    public GitCompareBranchesDialog(@NotNull Project project, @NotNull String branchName, @NotNull String currentBranchName, @NotNull GitCommitCompareInfo compareInfo, @NotNull GitRepository initialRepo, boolean dialog) {
        if (project == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(5);
        }
        if (branchName == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(6);
        }
        if (currentBranchName == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(7);
        }
        if (compareInfo == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(8);
        }
        if (initialRepo == null) {
            GitCompareBranchesDialog.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        String rootString = compareInfo.getRepositories().size() == 1 && GitUtil.getRepositoryManager(this.myProject).moreThanOneRoot() ? " in root " + DvcsUtil.getShortRepositoryName((Repository)initialRepo) : "";
        this.myTitle = String.format("Comparing %s with %s%s", currentBranchName, branchName, rootString);
        this.myMode = dialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        GitCompareBranchesDiffPanel diffPanel = new GitCompareBranchesDiffPanel(this.myProject, branchName, currentBranchName, compareInfo);
        this.myLogPanel = new GitCompareBranchesLogPanel(this.myProject, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab("Log", VcsLogIcons.Branch, (Component)this.myLogPanel);
        this.myTabbedPane.addTab("Files", AllIcons.Actions.ListChanges, (Component)diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    public void show() {
        if (this.myWrapper == null) {
            this.myWrapper = new WindowWrapperBuilder(this.myMode, (JComponent)this.myTabbedPane).setProject(this.myProject).setTitle(this.myTitle).setPreferredFocusedComponent((JComponent)this.myLogPanel).setDimensionServiceKey(GitCompareBranchesDialog.class.getName()).build();
        }
        this.myWrapper.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "branchName";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "currentBranchName";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "compareInfo";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "initialRepo";
                break;
            }
        }
        objectArray[1] = "git4idea/ui/branch/GitCompareBranchesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

