/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ManifestParser
extends DefaultHandler {
    private final String filename;
    private final URI baseUrl;
    private final String defaultBranch;
    private final Repository rootRepo;
    private final Map<String, Remote> remotes;
    private final Set<String> plusGroups;
    private final Set<String> minusGroups;
    private final List<RepoProject> projects;
    private final List<RepoProject> filteredProjects;
    private final IncludedFileReader includedReader;
    private String defaultRemote;
    private String defaultRevision;
    private int xmlInRead;
    private RepoProject currentProject;

    public ManifestParser(IncludedFileReader includedReader, String filename, String defaultBranch, String baseUrl, String groups, Repository rootRepo) {
        this.includedReader = includedReader;
        this.filename = filename;
        this.defaultBranch = defaultBranch;
        this.rootRepo = rootRepo;
        this.baseUrl = ManifestParser.normalizeEmptyPath(URI.create(baseUrl));
        this.plusGroups = new HashSet<String>();
        this.minusGroups = new HashSet<String>();
        if (groups == null || groups.length() == 0 || groups.equals("default")) {
            this.minusGroups.add("notdefault");
        } else {
            for (String group : groups.split(",")) {
                if (group.startsWith("-")) {
                    this.minusGroups.add(group.substring(1));
                    continue;
                }
                this.plusGroups.add(group);
            }
        }
        this.remotes = new HashMap<String, Remote>();
        this.projects = new ArrayList<RepoProject>();
        this.filteredProjects = new ArrayList<RepoProject>();
    }

    public void read(InputStream inputStream) throws IOException {
        XMLReader xr;
        ++this.xmlInRead;
        try {
            xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new IOException(JGitText.get().noXMLParserAvailable);
        }
        xr.setContentHandler(this);
        try {
            xr.parse(new InputSource(inputStream));
        }
        catch (SAXException e) {
            IOException error = new IOException(RepoText.get().errorParsingManifestFile);
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block43: {
            if ("project".equals(qName)) {
                if (attributes.getValue("name") == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject = new RepoProject(attributes.getValue("name"), attributes.getValue("path"), attributes.getValue("revision"), attributes.getValue("remote"), attributes.getValue("groups"));
                this.currentProject.setRecommendShallow(attributes.getValue("clone-depth"));
            } else if ("remote".equals(qName)) {
                String alias = attributes.getValue("alias");
                String fetch = attributes.getValue("fetch");
                String revision = attributes.getValue("revision");
                Remote remote = new Remote(fetch, revision);
                this.remotes.put(attributes.getValue("name"), remote);
                if (alias != null) {
                    this.remotes.put(alias, remote);
                }
            } else if ("default".equals(qName)) {
                this.defaultRemote = attributes.getValue("remote");
                this.defaultRevision = attributes.getValue("revision");
            } else if ("copyfile".equals(qName)) {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new RepoProject.CopyFile(this.rootRepo, this.currentProject.getPath(), attributes.getValue("src"), attributes.getValue("dest")));
            } else if ("include".equals(qName)) {
                String name = attributes.getValue("name");
                if (this.includedReader != null) {
                    try (InputStream is = this.includedReader.readIncludeFile(name);){
                        if (is == null) {
                            throw new SAXException(RepoText.get().errorIncludeNotImplemented);
                        }
                        this.read(is);
                        break block43;
                    }
                    catch (Exception e) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, name), e);
                    }
                }
                if (this.filename != null) {
                    int index = this.filename.lastIndexOf(47);
                    String path = this.filename.substring(0, index + 1) + name;
                    try (FileInputStream is = new FileInputStream(path);){
                        this.read(is);
                    }
                    catch (IOException e) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, path), e);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("project".equals(qName)) {
            this.projects.add(this.currentProject);
            this.currentProject = null;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        --this.xmlInRead;
        if (this.xmlInRead != 0) {
            return;
        }
        HashMap<String, URI> remoteUrls = new HashMap<String, URI>();
        if (this.defaultRevision == null && this.defaultRemote != null) {
            Remote remote = this.remotes.get(this.defaultRemote);
            if (remote != null) {
                this.defaultRevision = remote.revision;
            }
            if (this.defaultRevision == null) {
                this.defaultRevision = this.defaultBranch;
            }
        }
        for (RepoProject proj : this.projects) {
            String remote = proj.getRemote();
            String revision = this.defaultRevision;
            if (remote == null) {
                if (this.defaultRemote == null) {
                    if (this.filename != null) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefaultFilename, this.filename));
                    }
                    throw new SAXException(RepoText.get().errorNoDefault);
                }
                remote = this.defaultRemote;
            } else {
                Remote r = this.remotes.get(remote);
                if (r != null && r.revision != null) {
                    revision = r.revision;
                }
            }
            URI remoteUrl = (URI)remoteUrls.get(remote);
            if (remoteUrl == null) {
                String fetch = this.remotes.get((Object)remote).fetch;
                if (fetch == null) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorNoFetch, remote));
                }
                remoteUrl = ManifestParser.normalizeEmptyPath(this.baseUrl.resolve(fetch));
                remoteUrls.put(remote, remoteUrl);
            }
            proj.setUrl(remoteUrl.resolve(proj.getName()).toString()).setDefaultRevision(revision);
        }
        this.filteredProjects.addAll(this.projects);
        this.removeNotInGroup();
        this.removeOverlaps();
    }

    static URI normalizeEmptyPath(URI u) {
        if (u.getHost() != null && !u.getHost().isEmpty() && (u.getPath() == null || u.getPath().isEmpty())) {
            try {
                return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), "/", u.getQuery(), u.getFragment());
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException(x.getMessage(), x);
            }
        }
        return u;
    }

    public List<RepoProject> getProjects() {
        return this.projects;
    }

    @NonNull
    public List<RepoProject> getFilteredProjects() {
        return this.filteredProjects;
    }

    void removeNotInGroup() {
        Iterator<RepoProject> iter = this.filteredProjects.iterator();
        while (iter.hasNext()) {
            if (this.inGroups(iter.next())) continue;
            iter.remove();
        }
    }

    void removeOverlaps() {
        Collections.sort(this.filteredProjects);
        Iterator<RepoProject> iter = this.filteredProjects.iterator();
        if (!iter.hasNext()) {
            return;
        }
        RepoProject last = iter.next();
        while (iter.hasNext()) {
            RepoProject p = iter.next();
            if (last.isAncestorOf(p)) {
                iter.remove();
                continue;
            }
            last = p;
        }
        this.removeNestedCopyfiles();
    }

    void removeNestedCopyfiles() {
        for (RepoProject proj : this.filteredProjects) {
            ArrayList<RepoProject.CopyFile> copyfiles = new ArrayList<RepoProject.CopyFile>(proj.getCopyFiles());
            proj.clearCopyFiles();
            for (RepoProject.CopyFile copyfile : copyfiles) {
                if (this.isNestedCopyfile(copyfile)) continue;
                proj.addCopyFile(copyfile);
            }
        }
    }

    boolean inGroups(RepoProject proj) {
        for (String group : this.minusGroups) {
            if (!proj.inGroup(group)) continue;
            return false;
        }
        if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
            return true;
        }
        for (String group : this.plusGroups) {
            if (!proj.inGroup(group)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedCopyfile(RepoProject.CopyFile copyfile) {
        if (copyfile.dest.indexOf(47) == -1) {
            return false;
        }
        for (RepoProject proj : this.filteredProjects) {
            if (proj.getPath().compareTo(copyfile.dest) > 0) {
                return false;
            }
            if (!proj.isAncestorOf(copyfile.dest)) continue;
            return true;
        }
        return false;
    }

    private static class Remote {
        final String fetch;
        final String revision;

        Remote(String fetch, String revision) {
            this.fetch = fetch;
            this.revision = revision;
        }
    }

    public static interface IncludedFileReader {
        public InputStream readIncludeFile(String var1) throws GitAPIException, IOException;
    }
}

