/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterClientCache<T>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();

    public synchronized T getOrCreate(String id, ClientProvider<T> clientProvider) {
        T item = this.cache.get(id);
        if (item == null) {
            try {
                item = clientProvider.get();
                this.cache.put(id, item);
            }
            catch (Exception e) {
                LOG.warn("Error providing a new client for id=" + id, (Throwable)e);
                item = null;
            }
        }
        return item;
    }

    @Override
    public void close() {
        for (T client : this.cache.values()) {
            if (!(client instanceof Closeable)) continue;
            try {
                ((Closeable)client).close();
            }
            catch (Exception e) {
                LOG.warn("Error closing client " + client + ", ignoring...", (Throwable)e);
            }
        }
        this.cache.clear();
    }

    public static interface ClientProvider<T> {
        public T get() throws Exception;
    }
}

