/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.DELETEable;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.POSTable;
import org.apache.solr.rest.PUTable;
import org.apache.solr.rest.SolrSchemaRestApi;
import org.noggit.ObjectBuilder;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SCHEMA_BASE_PATH = "/schema";
    public static final String MANAGED_ENDPOINT = "/managed";
    private static final Pattern resourceIdRegex = Pattern.compile("(/config|/schema)(/.*)");
    private static final boolean DECODE = true;
    protected ManagedResourceStorage.StorageIO storageIO;
    protected Registry registry;
    protected Map<String, ManagedResource> managed = new TreeMap<String, ManagedResource>();
    protected RestManagerManagedResource endpoint;
    protected SolrResourceLoader loader;
    protected Router schemaRouter;
    protected Router configRouter;

    public static RestManager getRestManager(SolrRequestInfo solrRequestInfo) {
        RestManager restManager;
        if (solrRequestInfo == null) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No SolrRequestInfo in this Thread!");
        }
        SolrQueryRequest req = solrRequestInfo.getReq();
        RestManager restManager2 = restManager = req != null ? req.getCore().getRestManager() : null;
        if (restManager == null) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No RestManager found!");
        }
        return restManager;
    }

    public void init(SolrResourceLoader loader, NamedList<String> initArgs, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        log.debug("Initializing RestManager with initArgs: " + initArgs);
        if (storageIO == null) {
            throw new IllegalArgumentException("Must provide a valid StorageIO implementation to the RestManager!");
        }
        this.storageIO = storageIO;
        this.loader = loader;
        this.registry = loader.getManagedResourceRegistry();
        this.endpoint = new RestManagerManagedResource(this);
        this.endpoint.loadManagedDataAndNotify(null);
        this.managed.put("/schema/managed", this.endpoint);
        log.debug("Initializing {} registered ManagedResources", (Object)this.registry.registered.size());
        for (ManagedResourceRegistration reg : this.registry.registered.values()) {
            this.managed.put(reg.resourceId, this.createManagedResource(reg));
        }
        this.registry.initializedRestManager = this;
    }

    public synchronized ManagedResource addManagedResource(String resourceId, Class<? extends ManagedResource> clazz) {
        ManagedResource res;
        ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.registry.registered.get(resourceId);
        if (existingReg == null) {
            this.registry.registerManagedResource(resourceId, clazz, null);
            res = this.addRegisteredResource((ManagedResourceRegistration)this.registry.registered.get(resourceId));
        } else {
            res = this.getManagedResource(resourceId);
        }
        return res;
    }

    private synchronized ManagedResource addRegisteredResource(ManagedResourceRegistration reg) {
        Router router;
        String resourceId = reg.resourceId;
        ManagedResource res = this.createManagedResource(reg);
        this.managed.put(resourceId, res);
        log.info("Registered new managed resource {}", (Object)resourceId);
        Matcher resourceIdValidator = resourceIdRegex.matcher(resourceId);
        boolean validated = resourceIdValidator.matches();
        assert (validated) : "managed resourceId '" + resourceId + "' should already be validated by registerManagedResource()";
        String routerPath = resourceIdValidator.group(1);
        String path = resourceIdValidator.group(2);
        Router router2 = router = SCHEMA_BASE_PATH.equals(routerPath) ? this.schemaRouter : this.configRouter;
        if (router != null) {
            this.attachManagedResource(res, path, router);
        }
        return res;
    }

    protected ManagedResource createManagedResource(ManagedResourceRegistration reg) throws SolrException {
        ManagedResource res = null;
        try {
            Constructor<? extends ManagedResource> ctor = reg.implClass.getConstructor(String.class, SolrResourceLoader.class, ManagedResourceStorage.StorageIO.class);
            res = ctor.newInstance(reg.resourceId, this.loader, this.storageIO);
            res.loadManagedDataAndNotify(reg.observers);
        }
        catch (Exception e) {
            String errMsg = String.format(Locale.ROOT, "Failed to create new ManagedResource %s of type %s due to: %s", reg.resourceId, reg.implClass.getName(), e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg, (Throwable)e);
        }
        return res;
    }

    public ManagedResource getManagedResource(String resourceId) {
        ManagedResource res = this.getManagedResourceOrNull(resourceId);
        if (res == null) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No ManagedResource registered for path: " + resourceId);
        }
        return res;
    }

    public synchronized ManagedResource getManagedResourceOrNull(String resourceId) {
        return this.managed.get(resourceId);
    }

    public synchronized void deleteManagedResource(ManagedResource res) {
        String resourceId = res.getResourceId();
        ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.registry.registered.get(resourceId);
        int numObservers = existingReg.observers.size();
        if (numObservers > 0) {
            String errMsg = String.format(Locale.ROOT, "Cannot delete managed resource %s as it is being used by %d Solr components", resourceId, numObservers);
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, errMsg);
        }
        this.registry.registered.remove(resourceId);
        this.managed.remove(resourceId);
        try {
            res.onResourceDeleted();
        }
        catch (IOException e) {
            log.error("Error when trying to clean-up after deleting " + resourceId, (Throwable)e);
        }
    }

    public synchronized void attachManagedResources(String routerPath, Router router) {
        if (!SCHEMA_BASE_PATH.equals(routerPath)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, routerPath + " not supported by the RestManager");
        }
        this.schemaRouter = router;
        int numAttached = 0;
        for (String resourceId : this.managed.keySet()) {
            if (!resourceId.startsWith(routerPath)) continue;
            String path = resourceId.substring(routerPath.length());
            this.attachManagedResource(this.managed.get(resourceId), path, router);
            ++numAttached;
        }
        log.info("Attached {} ManagedResource endpoints to Restlet router: {}", (Object)numAttached, (Object)routerPath);
    }

    protected void attachManagedResource(ManagedResource res, String path, Router router) {
        router.attach(path, res.getServerResourceClass());
        log.info("Attached managed resource at path: {}", (Object)path);
        if (ManagedResource.ChildResourceSupport.class.isAssignableFrom(res.getClass())) {
            router.attach(path + "/{child}", res.getServerResourceClass());
        }
    }

    private static class RestManagerManagedResource
    extends ManagedResource {
        private static final String REST_MANAGER_STORAGE_ID = "/rest/managed";
        private final RestManager restManager;

        public RestManagerManagedResource(RestManager restManager) throws SolrException {
            super(REST_MANAGER_STORAGE_ID, restManager.loader, restManager.storageIO);
            this.restManager = restManager;
        }

        @Override
        protected synchronized void reloadFromStorage() throws SolrException {
            String resourceId = this.getResourceId();
            Object data = null;
            try {
                data = this.storage.load(resourceId);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ioExc) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to load stored data for " + resourceId + " due to: " + ioExc, (Throwable)ioExc);
            }
            Object managedData = this.processStoredData(data);
            if (this.managedInitArgs == null) {
                this.managedInitArgs = new NamedList();
            }
            if (managedData != null) {
                this.onManagedDataLoadedFromStorage(this.managedInitArgs, managedData);
            }
        }

        @Override
        protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
            if (managedData == null) {
                return;
            }
            List managedList = (List)managedData;
            for (Object next : managedList) {
                Map info = (Map)next;
                String implClass = (String)info.get("class");
                String resourceId = (String)info.get("resourceId");
                Class<ManagedResource> clazz = this.solrResourceLoader.findClass(implClass, ManagedResource.class);
                ManagedResourceRegistration existingReg = (ManagedResourceRegistration)this.restManager.registry.registered.get(resourceId);
                if (existingReg != null) continue;
                this.restManager.registry.registerManagedResource(resourceId, clazz, null);
            }
        }

        @Override
        public synchronized void doPut(BaseSolrResource endpoint, Representation entity, Object json) {
            if (!(json instanceof Map)) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Expected Map to create a new ManagedResource but received a " + json.getClass().getName());
            }
            String resourceId = ManagedEndpoint.resolveResourceId(endpoint.getRequest());
            Map info = (Map)json;
            info.put("resourceId", resourceId);
            this.storeManagedData(this.applyUpdatesToManagedData(json));
        }

        @Override
        protected Object applyUpdatesToManagedData(Object updates) {
            Map info = (Map)updates;
            String implClass = (String)info.get("class");
            String resourceId = (String)info.get("resourceId");
            log.info("Creating a new ManagedResource of type {} at path {}", (Object)implClass, (Object)resourceId);
            Class<ManagedResource> clazz = this.solrResourceLoader.findClass(implClass, ManagedResource.class);
            this.restManager.addManagedResource(resourceId, clazz);
            ArrayList<Map<String, String>> managedList = new ArrayList<Map<String, String>>();
            for (ManagedResourceRegistration reg : this.restManager.registry.getRegistered()) {
                if (!reg.observers.isEmpty()) continue;
                managedList.add(reg.getInfo());
            }
            return managedList;
        }

        @Override
        public void doDeleteChild(BaseSolrResource endpoint, String childId) {
            throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED);
        }

        @Override
        public void doGet(BaseSolrResource endpoint, String childId) {
            String path = ManagedEndpoint.resolveResourceId(endpoint.getRequest());
            Matcher resourceIdMatcher = resourceIdRegex.matcher(path);
            if (!resourceIdMatcher.matches()) {
                throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED, path);
            }
            String filter = resourceIdMatcher.group(1);
            ArrayList<Map<String, String>> regList = new ArrayList<Map<String, String>>();
            for (ManagedResourceRegistration reg : this.restManager.registry.getRegistered()) {
                if (!reg.resourceId.startsWith(filter) || RestManagerManagedResource.class.isAssignableFrom(reg.implClass)) continue;
                regList.add(reg.getInfo());
            }
            endpoint.getSolrResponse().add("managedResources", regList);
        }
    }

    public static class ManagedEndpoint
    extends BaseSolrResource
    implements GETable,
    PUTable,
    POSTable,
    DELETEable {
        protected ManagedResource managedResource;
        protected String childId;

        public static String resolveResourceId(Request restletReq) {
            String resourceId = restletReq.getResourceRef().getRelativeRef(restletReq.getRootRef().getParentRef()).getPath(true);
            if (!resourceId.startsWith("/")) {
                resourceId = "/" + resourceId;
            }
            return resourceId;
        }

        @Override
        public void doInit() throws ResourceException {
            int lastSlashAt;
            super.doInit();
            String resourceId = ManagedEndpoint.resolveResourceId(this.getRequest());
            RestManager restManager = RestManager.getRestManager(SolrRequestInfo.getRequestInfo());
            this.managedResource = restManager.getManagedResourceOrNull(resourceId);
            if (this.managedResource == null && (lastSlashAt = resourceId.lastIndexOf(47)) != -1) {
                String parentResourceId = resourceId.substring(0, lastSlashAt);
                log.info("Resource not found for {}, looking for parent: {}", (Object)resourceId, (Object)parentResourceId);
                this.managedResource = restManager.getManagedResourceOrNull(parentResourceId);
                if (this.managedResource != null) {
                    if (!(this.managedResource instanceof ManagedResource.ChildResourceSupport)) {
                        String errMsg = String.format(Locale.ROOT, "%s does not support child resources!", this.managedResource.getResourceId());
                        throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, errMsg);
                    }
                    this.childId = resourceId.substring(lastSlashAt + 1);
                    log.info("Found parent resource {} for child: {}", (Object)parentResourceId, (Object)this.childId);
                }
            }
            if (this.managedResource == null) {
                if (Method.PUT.equals((Object)this.getMethod()) || Method.POST.equals((Object)this.getMethod())) {
                    this.managedResource = restManager.endpoint;
                } else {
                    throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No REST managed resource registered for path " + resourceId);
                }
            }
            log.info("Found ManagedResource [" + this.managedResource + "] for " + resourceId);
        }

        @Override
        public Representation put(Representation entity) {
            try {
                this.managedResource.doPut(this, entity, this.parseJsonFromRequestBody(entity));
            }
            catch (Exception e) {
                this.getSolrResponse().setException(e);
            }
            this.handlePostExecution(log);
            return new BaseSolrResource.SolrOutputRepresentation();
        }

        @Override
        public Representation post(Representation entity) {
            try {
                this.managedResource.doPost(this, entity, this.parseJsonFromRequestBody(entity));
            }
            catch (Exception e) {
                this.getSolrResponse().setException(e);
            }
            this.handlePostExecution(log);
            return new BaseSolrResource.SolrOutputRepresentation();
        }

        @Override
        public Representation delete() {
            if (this.childId != null) {
                try {
                    this.managedResource.doDeleteChild(this, this.childId);
                }
                catch (Exception e) {
                    this.getSolrResponse().setException(e);
                }
            } else {
                try {
                    RestManager restManager = RestManager.getRestManager(SolrRequestInfo.getRequestInfo());
                    restManager.deleteManagedResource(this.managedResource);
                }
                catch (Exception e) {
                    this.getSolrResponse().setException(e);
                }
            }
            this.handlePostExecution(log);
            return new BaseSolrResource.SolrOutputRepresentation();
        }

        @Override
        public Representation get() {
            try {
                this.managedResource.doGet(this, this.childId);
            }
            catch (Exception e) {
                this.getSolrResponse().setException(e);
            }
            this.handlePostExecution(log);
            return new BaseSolrResource.SolrOutputRepresentation();
        }

        protected Object parseJsonFromRequestBody(Representation entity) {
            if (entity.getMediaType() == null) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String errMsg = String.format(Locale.ROOT, "Invalid content type %s; only %s is supported.", entity.getMediaType(), MediaType.APPLICATION_JSON.toString());
                log.error(errMsg);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, errMsg);
            }
            String text = null;
            try {
                text = entity.getText();
            }
            catch (IOException ioExc) {
                String errMsg = "Failed to read entity text due to: " + ioExc;
                log.error(errMsg, (Throwable)ioExc);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, errMsg, (Throwable)ioExc);
            }
            if (text == null || text.trim().length() == 0) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Empty request body!");
            }
            Object parsedJson = null;
            try {
                parsedJson = ObjectBuilder.fromJSON((String)text);
            }
            catch (IOException ioExc) {
                String errMsg = String.format(Locale.ROOT, "Failed to parse request [%s] into JSON due to: %s", text, ioExc.toString());
                log.error(errMsg, (Throwable)ioExc);
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, errMsg, (Throwable)ioExc);
            }
            return parsedJson;
        }

        @Override
        protected void addDeprecatedWarning() {
        }
    }

    public static class Registry {
        private Map<String, ManagedResourceRegistration> registered = new TreeMap<String, ManagedResourceRegistration>();
        private RestManager initializedRestManager = null;
        private final Set<String> reservedEndpoints = new HashSet<String>();
        private final Pattern reservedEndpointsPattern;

        public Registry() {
            this.reservedEndpoints.add("/schema/managed");
            for (String reservedEndpoint : SolrSchemaRestApi.getReservedEndpoints()) {
                this.reservedEndpoints.add(reservedEndpoint);
            }
            this.reservedEndpointsPattern = this.getReservedEndpointsPattern();
        }

        public Set<String> getReservedEndpoints() {
            return Collections.unmodifiableSet(this.reservedEndpoints);
        }

        private Pattern getReservedEndpointsPattern() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            boolean notFirst = false;
            for (String reservedEndpoint : this.reservedEndpoints) {
                if (notFirst) {
                    builder.append("|");
                } else {
                    notFirst = true;
                }
                builder.append(reservedEndpoint);
            }
            builder.append(")(?:|/.*)");
            return Pattern.compile(builder.toString());
        }

        public Collection<ManagedResourceRegistration> getRegistered() {
            return Collections.unmodifiableCollection(this.registered.values());
        }

        public synchronized void registerManagedResource(String resourceId, Class<? extends ManagedResource> implClass, ManagedResourceObserver observer) {
            if (resourceId == null) {
                throw new IllegalArgumentException("Must provide a non-null resourceId to register a ManagedResource!");
            }
            Matcher resourceIdValidator = resourceIdRegex.matcher(resourceId);
            if (!resourceIdValidator.matches()) {
                String errMsg = String.format(Locale.ROOT, "Invalid resourceId '%s'; must start with  %s.", resourceId, RestManager.SCHEMA_BASE_PATH);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
            }
            Matcher reservedEndpointsMatcher = this.reservedEndpointsPattern.matcher(resourceId);
            if (reservedEndpointsMatcher.matches()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, reservedEndpointsMatcher.group(1) + " is a reserved endpoint used by the Solr REST API!");
            }
            ManagedResourceRegistration reg = this.registered.get(resourceId);
            if (reg != null) {
                if (!reg.implClass.equals(implClass)) {
                    String errMsg = String.format(Locale.ROOT, "REST API path %s already registered to instances of %s", resourceId, reg.implClass.getName());
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMsg);
                }
                if (observer != null) {
                    reg.observers.add(observer);
                    log.info("Added observer of type {} to existing ManagedResource {}", (Object)observer.getClass().getName(), (Object)resourceId);
                }
            } else {
                this.registered.put(resourceId, new ManagedResourceRegistration(resourceId, implClass, observer));
                log.info("Registered ManagedResource impl {} for path {}", (Object)implClass.getName(), (Object)resourceId);
            }
            if (this.initializedRestManager != null) {
                this.initializedRestManager.addRegisteredResource(this.registered.get(resourceId));
            }
        }
    }

    private static class ManagedResourceRegistration {
        String resourceId;
        Class<? extends ManagedResource> implClass;
        List<ManagedResourceObserver> observers = new ArrayList<ManagedResourceObserver>();

        private ManagedResourceRegistration(String resourceId, Class<? extends ManagedResource> implClass, ManagedResourceObserver observer) {
            this.resourceId = resourceId;
            this.implClass = implClass;
            if (observer != null) {
                this.observers.add(observer);
            }
        }

        public Map<String, String> getInfo() {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("resourceId", this.resourceId);
            info.put("class", this.implClass.getName());
            info.put("numObservers", String.valueOf(this.observers.size()));
            return info;
        }
    }
}

