/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.NumericStatsValues;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.schema.NumberType;

public class SortedNumericStatsValues
implements StatsValues {
    private final NumericStatsValues nsv;
    private final String fieldName;
    private final NumberType numberType;
    private SortedNumericDocValues sndv;

    public SortedNumericStatsValues(NumericStatsValues nsv, StatsField field) {
        this.nsv = nsv;
        this.fieldName = field.getSchemaField().getName();
        this.numberType = field.getSchemaField().getType().getNumberType();
    }

    @Override
    public void accumulate(NamedList stv) {
        this.nsv.accumulate(stv);
    }

    @Override
    public void accumulate(int docId) throws IOException {
        if (!this.sndv.advanceExact(docId)) {
            this.missing();
        } else {
            for (int i = 0; i < this.sndv.docValueCount(); ++i) {
                this.nsv.accumulate(this.toCorrectType(this.sndv.nextValue()), 1);
            }
        }
    }

    private Number toCorrectType(long value) {
        switch (this.numberType) {
            case INTEGER: 
            case LONG: {
                return value;
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)value)));
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)value);
            }
        }
        throw new AssertionError((Object)"Unsupported number type");
    }

    @Override
    public void accumulate(BytesRef value, int count) {
        this.nsv.accumulate(value, count);
    }

    @Override
    public void missing() {
        this.nsv.missing();
    }

    @Override
    public void addMissing(int count) {
        this.nsv.addMissing(count);
    }

    @Override
    public void addFacet(String facetName, Map<String, StatsValues> facetValues) {
        this.nsv.addFacet(facetName, facetValues);
    }

    @Override
    public NamedList<?> getStatsValues() {
        return this.nsv.getStatsValues();
    }

    @Override
    public void setNextReader(LeafReaderContext ctx) throws IOException {
        this.sndv = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.fieldName);
        assert (this.sndv != null);
    }
}

