/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;

public abstract class FilteredDocIdSet
extends DocIdSet {
    private final DocIdSet _innerSet;

    public FilteredDocIdSet(DocIdSet innerSet) {
        this._innerSet = innerSet;
    }

    public DocIdSet getDelegate() {
        return this._innerSet;
    }

    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this._innerSet.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return this._innerSet.getChildResources();
    }

    public Bits bits() throws IOException {
        final Bits bits = this._innerSet.bits();
        return bits == null ? null : new Bits(){

            public boolean get(int docid) {
                return bits.get(docid) && FilteredDocIdSet.this.match(docid);
            }

            public int length() {
                return bits.length();
            }
        };
    }

    protected abstract boolean match(int var1);

    public DocIdSetIterator iterator() throws IOException {
        DocIdSetIterator iterator = this._innerSet.iterator();
        if (iterator == null) {
            return null;
        }
        return new FilteredDocIdSetIterator(iterator){

            protected boolean match(int docid) {
                return FilteredDocIdSet.this.match(docid);
            }
        };
    }
}

