#!/bin/sh
export PATH='/usr/obj/ports/hs-cryptohash-0.7.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: cryptohash
version: 0.7.10
id: cryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
key: cryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: http://github.com/vincenthz/hs-cryptohash
synopsis: collection of crypto hashes, fast, pure and practical
description:
    A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
    with performance close to the fastest implementations available in others languages.
    .
    The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
    Crypto.Hash.RIPEMD160 Crypto.Hash.SHA1 Crypto.Hash.SHA224
    Crypto.Hash.SHA256 Crypto.Hash.SHA3 Crypto.Hash.SHA384
    Crypto.Hash.SHA512 Crypto.Hash.SHA512t Crypto.Hash.Skein256
    Crypto.Hash.Skein512 Crypto.Hash.Tiger Crypto.Hash.Whirlpool
    Crypto.MAC.HMAC
abi: 325ac57f96a1978eadc1ec5f8ce424ef
trusted: False
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.10
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-cryptohash-0.7.10
hs-libraries: HScryptohash-0.7.10-HcwvxMqpgmiAmodT7Z0qKE
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    crypto-api-0.13.2-HdoaNKgPjwIDvahrsdJlLG
    tagged-0.7.3-JOGLvm4jfLWGOxvLgFJbwZ
    cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             crypto-api-0.13.2-HdoaNKgPjwIDvahrsdJlLG=e11826d84c6ce86ac2be54dc28b7a5ca
             tagged-0.7.3-JOGLvm4jfLWGOxvLgFJbwZ=2dc6c7e3710cd013a1e68ae10afec85b
             cereal-0.4.1.0-J7JNgMSSYgsLRU6KWtlHY0=1033285ec206c99e1643a2fa74b567ef
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.10/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

