#!/bin/sh
export PATH='/usr/obj/ports/hs-hackage-security-0.5.2.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hackage-security
version: 0.5.2.2
id: hackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
key: hackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
indefinite: False
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: faa0588c1800b583ebbf70f3311ce10b
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-security-0.5.2.2
library-dirs: /usr/local/lib/ghc/hackage-security-0.5.2.2
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-hackage-security-0.5.2.2
hs-libraries: HShackage-security-0.5.2.2-2xPvTJk9eMUH8RAihmaWhK
depends:
    base-4.10.1.0 base16-bytestring-0.1.1.5-6C0w7pcEjtRYQOqmnwyBO
    base64-bytestring-1.0.0.0-1by0UXugZ1QA46cGNBhjge
    bytestring-0.10.8.2 Cabal-2.0.1.0 containers-0.5.10.2
    directory-1.3.0.2 ed25519-0.0.5.0-3Sle7uACwGIJ1UEE9iZB8E
    filepath-1.4.1.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parsec-3.1.9-444fzLM2idQ5vByZuGIOJ pretty-1.1.3.3
    cryptohash-sha256-0.11.101.0-2y5kOPF2abcAQTysw8Z7cK
    tar-0.5.0.3-4RaKOzbHzG1EpSAqFcpBFH time-1.8.0.2
    transformers-0.5.2.0 zlib-0.5.4.2-F6BHJqwkis53HpMy7MLAqK
    template-haskell-2.12.0.0 ghc-prim-0.5.1.1
    network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             base16-bytestring-0.1.1.5-6C0w7pcEjtRYQOqmnwyBO=2df6dce43177f65cd2c2fe50d772dae7
             base64-bytestring-1.0.0.0-1by0UXugZ1QA46cGNBhjge=66c52cf906134009e5a9a63fb1c48600
             bytestring-0.10.8.2=3f834c69e2158c4ad5032b0346c29480
             Cabal-2.0.1.0=7bc7ffb5e2c8451ab397317cb02e0228
             containers-0.5.10.2=a2c92baf4a812b005ca4fa7f0772cd30
             directory-1.3.0.2=1eef9b3048ad9e2e85c4a64b4bf56e7e
             ed25519-0.0.5.0-3Sle7uACwGIJ1UEE9iZB8E=e4e87cdbdce2305f24bbc002d1e0ef10
             filepath-1.4.1.2=ef9a1704901889a61779624199ca7499
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=ff60e0c200c475a016137ee0a9ed1f03
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=7e464826ac815eee6510ec2a536780a9
             pretty-1.1.3.3=7e4ff47e6f9a790083a87f97e74bf9b6
             cryptohash-sha256-0.11.101.0-2y5kOPF2abcAQTysw8Z7cK=2f164fc5cd9bd32c5f66800e2b135718
             tar-0.5.0.3-4RaKOzbHzG1EpSAqFcpBFH=a75909215af46c5546b51a5667ba305c
             time-1.8.0.2=4e7e761020e68f00617832ab1b4f94d5
             transformers-0.5.2.0=650a984849062cc36a998e6c890bf69a
             zlib-0.5.4.2-F6BHJqwkis53HpMy7MLAqK=4a651718524071c4ec645112da1bc5ca
             template-haskell-2.12.0.0=c86c34a1f7deb29023e2cbca17d693d7
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0=3530b9bb3ea3a140fd78e741bc1faf5d
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=8851adc1c0835b2434fe123b5bcd5394
haddock-interfaces: /usr/local/share/doc/hs-hackage-security-0.5.2.2/html/hackage-security.haddock
haddock-html: /usr/local/share/doc/hs-hackage-security-0.5.2.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

