/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class MultipolygonBuilder {
    private static final ForkJoinPool THREAD_POOL = Utils.newForkJoinPool("multipolygon_creation.numberOfThreads", "multipolygon-builder-%d", 5);
    public final List<JoinedPolygon> outerWays;
    public final List<JoinedPolygon> innerWays;

    public MultipolygonBuilder(List<JoinedPolygon> outerWays, List<JoinedPolygon> innerWays) {
        this.outerWays = outerWays;
        this.innerWays = innerWays;
    }

    public MultipolygonBuilder() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> ways) {
        try {
            List<JoinedPolygon> joinedWays = MultipolygonBuilder.joinWays(ways);
            return this.makeFromPolygons(joinedWays);
        }
        catch (JoinedPolygonCreationException ex) {
            Logging.debug(ex);
            return ex.getMessage();
        }
    }

    public static Pair<List<JoinedPolygon>, List<JoinedPolygon>> joinWays(Relation multipolygon) {
        CheckParameterUtil.ensureThat(multipolygon.isMultipolygon(), "multipolygon.isMultipolygon");
        Map members = multipolygon.getMembers().stream().filter(RelationMember::isWay).collect(Collectors.groupingBy(RelationMember::getRole, Collectors.mapping(RelationMember::getWay, Collectors.toSet())));
        List<JoinedPolygon> outerRings = MultipolygonBuilder.joinWays(members.getOrDefault("outer", Collections.emptySet()));
        List<JoinedPolygon> innerRings = MultipolygonBuilder.joinWays(members.getOrDefault("inner", Collections.emptySet()));
        return Pair.create(outerRings, innerRings);
    }

    public static List<JoinedPolygon> joinWays(Collection<Way> ways) {
        ArrayList<JoinedPolygon> joinedWays = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> nodesWithConnectedWays = new MultiMap<Node, Way>();
        HashSet<Way> usedWays = new HashSet<Way>();
        for (Way w : ways) {
            if (w.getNodesCount() < 2) {
                throw new JoinedPolygonCreationException(I18n.tr("Cannot add a way with only {0} nodes.", w.getNodesCount()));
            }
            if (w.isClosed()) {
                JoinedPolygon jw = new JoinedPolygon(w);
                joinedWays.add(jw);
                usedWays.add(w);
                continue;
            }
            nodesWithConnectedWays.put(w.lastNode(), w);
            nodesWithConnectedWays.put(w.firstNode(), w);
        }
        for (Way startWay : ways) {
            if (usedWays.contains(startWay)) continue;
            Node startNode = startWay.firstNode();
            ArrayList<Way> collectedWays = new ArrayList<Way>();
            ArrayList<Boolean> collectedWaysReverse = new ArrayList<Boolean>();
            Way curWay = startWay;
            Node prevNode = startNode;
            while (true) {
                boolean curWayReverse = prevNode == curWay.lastNode();
                Node nextNode = curWayReverse ? curWay.firstNode() : curWay.lastNode();
                collectedWays.add(curWay);
                collectedWaysReverse.add(curWayReverse);
                if (nextNode == startNode) break;
                Set adjacentWays = nodesWithConnectedWays.get(nextNode);
                if (adjacentWays.size() != 2) {
                    throw new JoinedPolygonCreationException(I18n.tr("Each node must connect exactly 2 ways", new Object[0]));
                }
                Way nextWay = null;
                for (Way way : adjacentWays) {
                    if (way == curWay) continue;
                    nextWay = way;
                }
                curWay = nextWay;
                prevNode = nextNode;
            }
            usedWays.addAll(collectedWays);
            joinedWays.add(new JoinedPolygon(collectedWays, collectedWaysReverse));
        }
        return joinedWays;
    }

    private String makeFromPolygons(List<JoinedPolygon> polygons) {
        List<PolygonLevel> list = MultipolygonBuilder.findOuterWaysMultiThread(polygons);
        if (list == null) {
            return I18n.tr("There is an intersection between ways.", new Object[0]);
        }
        this.outerWays.clear();
        this.innerWays.clear();
        for (PolygonLevel pol : list) {
            if (pol.level % 2 == 0) {
                this.outerWays.add(pol.outerWay);
                continue;
            }
            this.innerWays.add(pol.outerWay);
        }
        return null;
    }

    private static Pair<Boolean, List<JoinedPolygon>> findInnerWaysCandidates(IntersectionMatrix cache, JoinedPolygon outerWay, Collection<JoinedPolygon> boundaryWays) {
        boolean outerGood = true;
        ArrayList<JoinedPolygon> innerCandidates = new ArrayList<JoinedPolygon>();
        for (JoinedPolygon innerWay : boundaryWays) {
            if (innerWay == outerWay || !outerWay.bounds.intersects(innerWay.bounds)) continue;
            Geometry.PolygonIntersection intersection = cache.computeIfAbsent(outerWay, innerWay, () -> Geometry.polygonIntersection(outerWay.area, innerWay.area));
            if (intersection == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                outerGood = false;
                break;
            }
            if (intersection == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                innerCandidates.add(innerWay);
                continue;
            }
            if (intersection != Geometry.PolygonIntersection.CROSSING) continue;
            return null;
        }
        return new Pair<Boolean, List<JoinedPolygon>>(outerGood, innerCandidates);
    }

    private static List<PolygonLevel> findOuterWaysMultiThread(List<JoinedPolygon> boundaryWays) {
        IntersectionMatrix cache = new IntersectionMatrix(boundaryWays);
        return THREAD_POOL.invoke(new Worker(cache, boundaryWays, 0, boundaryWays.size(), new ArrayList<PolygonLevel>(), Math.max(32, boundaryWays.size() / THREAD_POOL.getParallelism() / 3)));
    }

    private static class Worker
    extends RecursiveTask<List<PolygonLevel>> {
        private static final long serialVersionUID = 1L;
        private final transient List<JoinedPolygon> input;
        private final int from;
        private final int to;
        private final transient List<PolygonLevel> output;
        private final int directExecutionTaskSize;
        private final IntersectionMatrix cache;

        Worker(IntersectionMatrix cache, List<JoinedPolygon> input, int from, int to, List<PolygonLevel> output, int directExecutionTaskSize) {
            this.cache = cache;
            this.input = input;
            this.from = from;
            this.to = to;
            this.output = output;
            this.directExecutionTaskSize = directExecutionTaskSize;
        }

        private static List<PolygonLevel> findOuterWaysRecursive(int level, IntersectionMatrix cache, List<JoinedPolygon> boundaryWays) {
            ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
            for (JoinedPolygon outerWay : boundaryWays) {
                if (Worker.processOuterWay(level, cache, boundaryWays, result, outerWay) != null) continue;
                return null;
            }
            return result;
        }

        private static List<PolygonLevel> processOuterWay(int level, IntersectionMatrix cache, List<JoinedPolygon> boundaryWays, List<PolygonLevel> result, JoinedPolygon outerWay) {
            Pair p = MultipolygonBuilder.findInnerWaysCandidates(cache, outerWay, boundaryWays);
            if (p == null) {
                return null;
            }
            if (((Boolean)p.a).booleanValue()) {
                PolygonLevel pol = new PolygonLevel(outerWay, level);
                if (!((List)p.b).isEmpty()) {
                    List<PolygonLevel> innerList = Worker.findOuterWaysRecursive(level + 1, cache, (List)p.b);
                    if (innerList == null) {
                        return null;
                    }
                    result.addAll(innerList);
                    for (PolygonLevel pl : innerList) {
                        if (pl.level != level + 1) continue;
                        pol.innerWays.add(pl.outerWay);
                    }
                }
                result.add(pol);
            }
            return result;
        }

        @Override
        protected List<PolygonLevel> compute() {
            if (this.to - this.from <= this.directExecutionTaskSize) {
                return this.computeDirectly();
            }
            ArrayList<Worker> tasks = new ArrayList<Worker>();
            for (int fromIndex = this.from; fromIndex < this.to; fromIndex += this.directExecutionTaskSize) {
                tasks.add(new Worker(this.cache, this.input, fromIndex, Math.min(fromIndex + this.directExecutionTaskSize, this.to), new ArrayList<PolygonLevel>(), this.directExecutionTaskSize));
            }
            for (ForkJoinTask task : ForkJoinTask.invokeAll(tasks)) {
                List res = (List)task.join();
                if (res == null) {
                    return null;
                }
                this.output.addAll(res);
            }
            return this.output;
        }

        List<PolygonLevel> computeDirectly() {
            for (int i = this.from; i < this.to; ++i) {
                if (Worker.processOuterWay(0, this.cache, this.input, this.output, this.input.get(i)) != null) continue;
                return null;
            }
            return this.output;
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
        }
    }

    public static class JoinedPolygonCreationException
    extends RuntimeException {
        public JoinedPolygonCreationException(String message) {
            super(message);
        }
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        PolygonLevel(JoinedPolygon pol, int level) {
            this.outerWay = pol;
            this.level = level;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;
        public final Area area;
        public final Rectangle bounds;

        public JoinedPolygon(List<Way> ways, List<Boolean> reversed) {
            this.ways = ways;
            this.reversed = reversed;
            this.nodes = this.getNodes();
            this.area = Geometry.getArea(this.nodes);
            this.bounds = this.area.getBounds();
        }

        public JoinedPolygon(Way way) {
            this(Collections.singletonList(way), Collections.singletonList(Boolean.FALSE));
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int waypos = 0; waypos < this.ways.size(); ++waypos) {
                int pos;
                Way way = this.ways.get(waypos);
                boolean reversed = this.reversed.get(waypos);
                if (!reversed) {
                    for (pos = 0; pos < way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.getNode(pos));
                }
            }
            return nodes;
        }
    }

    private static class IntersectionMatrix {
        private final Map<Pair<JoinedPolygon, JoinedPolygon>, Geometry.PolygonIntersection> results;

        IntersectionMatrix(Collection<JoinedPolygon> polygons) {
            this.results = new HashMap<Pair<JoinedPolygon, JoinedPolygon>, Geometry.PolygonIntersection>(Utils.hashMapInitialCapacity(polygons.size() * polygons.size()));
        }

        private Geometry.PolygonIntersection getReverseIntersectionResult(Geometry.PolygonIntersection intersection) {
            switch (intersection) {
                case FIRST_INSIDE_SECOND: {
                    return Geometry.PolygonIntersection.SECOND_INSIDE_FIRST;
                }
                case SECOND_INSIDE_FIRST: {
                    return Geometry.PolygonIntersection.FIRST_INSIDE_SECOND;
                }
            }
            return intersection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Geometry.PolygonIntersection computeIfAbsent(JoinedPolygon a1, JoinedPolygon a2, Supplier<Geometry.PolygonIntersection> computation) {
            Geometry.PolygonIntersection intersection = this.results.get(Pair.create(a1, a2));
            if (intersection == null) {
                intersection = computation.get();
                Map<Pair<JoinedPolygon, JoinedPolygon>, Geometry.PolygonIntersection> map = this.results;
                synchronized (map) {
                    this.results.put(Pair.create(a1, a2), intersection);
                    this.results.put(Pair.create(a2, a1), this.getReverseIntersectionResult(intersection));
                }
            }
            return intersection;
        }
    }
}

