/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.input;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class MouseTest {
    private int direction;
    private int lastButton;
    private int lastScrollDirection = -1;
    private static int WINDOW_WIDTH = 640;
    private static int WINDOW_HEIGHT = 640;
    private Vector2f triangleSize = new Vector2f(120.0f, 100.0f);
    private Vector3f[] triangleColors = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    private Vector3f[] quadColors = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    private Vector2f[] triangles;
    private boolean closing;
    public static final boolean FULLSCREEN = false;

    public MouseTest() {
        this.triangles = new Vector2f[]{new Vector2f((float)(WINDOW_WIDTH / 2), (float)WINDOW_HEIGHT - this.triangleSize.y), new Vector2f(this.triangleSize.y, (float)(WINDOW_HEIGHT / 2)), new Vector2f((float)(WINDOW_WIDTH / 2), this.triangleSize.y), new Vector2f((float)WINDOW_WIDTH - this.triangleSize.y, (float)(WINDOW_HEIGHT / 2))};
    }

    private void initialize() {
        this.setupDisplay();
        this.setupMouse();
        this.setupKeyboard();
    }

    private void setupDisplay() {
        try {
            this.setDisplayMode();
            Display.setFullscreen((boolean)false);
            Display.setVSyncEnabled((boolean)true);
            Display.create();
            Mouse.setGrabbed((boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.initializeOpenGL();
    }

    protected boolean setDisplayMode() {
        DisplayMode dm = new DisplayMode(WINDOW_WIDTH, WINDOW_HEIGHT);
        try {
            Display.setDisplayMode((DisplayMode)dm);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void initializeOpenGL() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)Display.getDisplayMode().getWidth(), (float)0.0f, (float)Display.getDisplayMode().getHeight());
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void executeTest() {
        this.initialize();
        this.runTest();
        Display.destroy();
    }

    private void setupMouse() {
    }

    private void setupKeyboard() {
    }

    private void runTest() {
        while (!this.closing) {
            this.handleWindow();
            if (!this.closing) {
                this.handleKeyboard();
                this.handleMouse();
                if (!Display.isVisible()) {
                    if (Display.isDirty()) {
                        this.render();
                    }
                    this.pause(100L);
                    continue;
                }
                this.logic();
                this.render();
            }
            Thread.yield();
        }
    }

    private void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException inte) {
            inte.printStackTrace();
        }
    }

    private void handleWindow() {
        Display.update();
        this.closing = Display.isCloseRequested();
    }

    private void handleMouse() {
        this.readBufferedMouse();
        Display.setTitle((String)("x: " + Mouse.getX() + ", y: " + Mouse.getY() + ", [0]: " + Mouse.isButtonDown((int)0) + ", [1]: " + Mouse.isButtonDown((int)1) + ", [2]: " + Mouse.isButtonDown((int)2) + ", inside: " + Mouse.isInsideWindow()));
    }

    private void readBufferedMouse() {
        while (Mouse.next()) {
            if (Mouse.getEventButton() == -1 || !Mouse.getEventButtonState()) continue;
            this.lastButton = Mouse.getEventButton();
        }
        this.updateState();
    }

    private void updateState() {
        this.direction = -1;
        int dx = Mouse.getDX();
        int dy = Mouse.getDY();
        int dw = Mouse.getDWheel();
        if (dx == dy && dx == 0 && dw == 0) {
            return;
        }
        if (dx > 0) {
            this.direction = 3;
        }
        if (dx < 0) {
            this.direction = 1;
        }
        if (dy > 0) {
            this.direction = 0;
        }
        if (dy < 0) {
            this.direction = 2;
        }
        if (this.direction > -1) {
            switch (this.lastButton) {
                case -1: {
                    break;
                }
                case 1: {
                    this.triangleColors[this.direction].y = 1.0f;
                    break;
                }
                case 2: {
                    this.triangleColors[this.direction].z = 1.0f;
                    break;
                }
                case 3: {
                    this.triangleColors[this.direction].x = 1.0f;
                    this.triangleColors[this.direction].y = 1.0f;
                    this.triangleColors[this.direction].z = 1.0f;
                    break;
                }
                default: {
                    this.triangleColors[this.direction].x = 1.0f;
                }
            }
        }
        if (dw > 0) {
            ++this.lastScrollDirection;
        } else if (dw < 0) {
            --this.lastScrollDirection;
        } else if (dw == 0) {
            return;
        }
        if (this.lastScrollDirection < 0) {
            this.lastScrollDirection = 3;
        }
        if (this.lastScrollDirection > 3) {
            this.lastScrollDirection = 0;
        }
        this.quadColors[this.lastScrollDirection].x = (float)Math.random();
        this.quadColors[this.lastScrollDirection].y = (float)Math.random();
        this.quadColors[this.lastScrollDirection].z = (float)Math.random();
    }

    private void handleKeyboard() {
        while (Keyboard.next()) {
            if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                this.closing = true;
            }
            if (Keyboard.getEventKey() == 57 && Keyboard.getEventKeyState()) {
                Mouse.setGrabbed((!Mouse.isGrabbed() ? 1 : 0) != 0);
            }
            if (Keyboard.getEventKey() != 19 || !Keyboard.getEventKeyState()) continue;
            Display.setResizable((!Display.isResizable() ? 1 : 0) != 0);
        }
    }

    private void logic() {
        for (Vector3f color : this.triangleColors) {
            color.x = (float)((double)color.x - 0.01);
            color.y = (float)((double)color.y - 0.01);
            color.z = (float)((double)color.z - 0.01);
        }
        for (Vector3f color : this.quadColors) {
            color.x = (float)((double)color.x - 0.01);
            color.y = (float)((double)color.y - 0.01);
            color.z = (float)((double)color.z - 0.01);
        }
    }

    private void render() {
        GL11.glClear((int)16384);
        for (int i = 0; i < this.triangles.length; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.triangles[i].x, (float)this.triangles[i].y, (float)0.0f);
            GL11.glRotatef((float)(i * 90), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glColor3f((float)this.triangleColors[i].x, (float)this.triangleColors[i].y, (float)this.triangleColors[i].z);
            GL11.glBegin((int)4);
            GL11.glVertex2f((float)0.0f, (float)this.triangleSize.y);
            GL11.glVertex2f((float)(-this.triangleSize.x), (float)(-this.triangleSize.y));
            GL11.glVertex2f((float)this.triangleSize.x, (float)(-this.triangleSize.y));
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        GL11.glBegin((int)7);
        GL11.glColor3f((float)this.quadColors[0].x, (float)this.quadColors[0].y, (float)this.quadColors[0].z);
        GL11.glVertex2f((float)((float)(WINDOW_WIDTH / 2) - this.triangleSize.x), (float)((float)(WINDOW_HEIGHT / 2) - this.triangleSize.x));
        GL11.glColor3f((float)this.quadColors[1].x, (float)this.quadColors[1].y, (float)this.quadColors[1].z);
        GL11.glVertex2f((float)((float)(WINDOW_WIDTH / 2) + this.triangleSize.x), (float)((float)(WINDOW_HEIGHT / 2) - this.triangleSize.x));
        GL11.glColor3f((float)this.quadColors[2].x, (float)this.quadColors[2].y, (float)this.quadColors[2].z);
        GL11.glVertex2f((float)((float)(WINDOW_WIDTH / 2) + this.triangleSize.x), (float)((float)(WINDOW_HEIGHT / 2) + this.triangleSize.x));
        GL11.glColor3f((float)this.quadColors[3].x, (float)this.quadColors[3].y, (float)this.quadColors[3].z);
        GL11.glVertex2f((float)((float)(WINDOW_WIDTH / 2) - this.triangleSize.x), (float)((float)(WINDOW_HEIGHT / 2) + this.triangleSize.x));
        GL11.glEnd();
    }

    public static void main(String[] args) {
        MouseTest mt = new MouseTest();
        mt.executeTest();
        System.exit(0);
    }
}

