/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core;

import com.projity.grouping.core.GroupNodeImpl;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeBridge;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.transform.grouping.NodeGroup;
import com.projity.pm.resource.EnterpriseResource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.undo.DataFactoryUndoController;

public class NodeFactory {
    protected static NodeFactory instance = null;

    protected NodeFactory() {
    }

    public static NodeFactory getInstance() {
        if (instance == null) {
            instance = new NodeFactory();
        }
        return instance;
    }

    public Node createVirtualNode(Class clazz) {
        Node node = this.createNode(clazz);
        node.setVirtual(true);
        return node;
    }

    public Node createNode(Class clazz) {
        try {
            Node node = (Node)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return new NodeBridge(node);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node createNode(Object object) {
        try {
            return new NodeBridge(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node createTask(Project project) {
        return new NodeBridge(new NormalTask(project));
    }

    public Node createResource(ResourcePool resourcePool) {
        return new NodeBridge(new ResourceImpl(new EnterpriseResource(resourcePool)));
    }

    public Node createVoidNode() {
        try {
            NodeBridge nodeBridge = new NodeBridge(new VoidNodeImpl());
            nodeBridge.setVoid(true);
            return nodeBridge;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node createRootNode() {
        try {
            NodeBridge nodeBridge = new NodeBridge(new VoidNodeImpl());
            nodeBridge.setRoot(true);
            return nodeBridge;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node createGroup(NodeGroup nodeGroup, String string) {
        try {
            GroupNodeImpl groupNodeImpl = new GroupNodeImpl();
            groupNodeImpl.setName(string == null ? nodeGroup.getSorterId() : string);
            return new NodeBridge(groupNodeImpl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Node createTestNode() {
        try {
            Project project = Project.createProject(null, new DataFactoryUndoController());
            NormalTask normalTask = project.newNormalTaskInstance();
            normalTask.setName("this is the task name");
            return new NodeBridge(normalTask);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

