/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.association.InvalidAssociationException;
import com.projity.functor.IntervalConsumer;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.graphic.gantt.Gantt;
import com.projity.pm.graphic.gantt.GanttPopupMenu;
import com.projity.pm.graphic.gantt.GanttUI;
import com.projity.pm.graphic.graph.GraphInteractor;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.scheduling.ScheduleService;
import com.projity.util.Alert;
import com.projity.util.ClassUtils;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class GanttInteractor
extends GraphInteractor {
    private static final long serialVersionUID = -555882007216388246L;
    protected static final int BAR_MOVE_START = 4;
    protected static final int BAR_MOVE_END = 5;
    protected static final int PROGRESS_BAR_MOVE = 6;
    protected static final int SPLIT = 7;
    protected ScheduleInterval selectedInterval;
    protected int selectedIntervalNumber;
    protected double t;
    private NodeSelectionIntervalConsumer nodeSelectionIntervalConsumer = new NodeSelectionIntervalConsumer();

    public GanttInteractor(GraphUI graphUI) {
        super(graphUI);
        this.popup = new GanttPopupMenu(this);
    }

    protected void computeNodeSelection(double d, double d2) {
        GraphicNode graphicNode = (GraphicNode)this.selected;
        graphicNode.consumeIntervals(this.nodeSelectionIntervalConsumer.init(d, graphicNode));
    }

    protected Shape getBarShadowBounds(double d, double d2) {
        Rectangle2D.Double double_;
        double d3 = d - this.x0;
        CoordinatesConverter coordinatesConverter = this.getCoord();
        GraphicNode graphicNode = (GraphicNode)this.selected;
        double d4 = coordinatesConverter.toX(this.selectedIntervalNumber == 0 && this.state == 3 ? (double)graphicNode.getStart() : (double)this.selectedInterval.getStart());
        if (this.state == 6) {
            double d5 = coordinatesConverter.toX(graphicNode.getCompleted());
            double_ = new Rectangle2D.Double(d4, ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset() + (graphicNode.getGanttShapeHeight() - (double)this.config.getGanttProgressBarHeight()) / 2.0, d5 - d4 + d3, this.config.getGanttProgressBarHeight());
        } else {
            double d6 = this.selectedIntervalNumber == 0 && this.state == 3 ? CoordinatesConverter.adaptSmallBarEndX(coordinatesConverter.toX(graphicNode.getStart()), coordinatesConverter.toX(graphicNode.getEnd()), graphicNode, this.config) : coordinatesConverter.toX(this.selectedInterval.getEnd());
            double d7 = d6 - d4;
            switch (this.state) {
                case 3: {
                    double_ = new Rectangle2D.Double(d4 + d3, ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset(), d7, graphicNode.getGanttShapeHeight());
                    break;
                }
                case 4: {
                    double_ = new Rectangle2D.Double(d4 + d3, ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset(), d7 - d3, graphicNode.getGanttShapeHeight());
                    break;
                }
                case 5: {
                    double_ = new Rectangle2D.Double(d4, ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset(), d7 + d3, graphicNode.getGanttShapeHeight());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return double_;
    }

    protected Rectangle2D getLinkSelectionShadowBounds(GraphicNode graphicNode) {
        CoordinatesConverter coordinatesConverter = this.getCoord();
        double d = coordinatesConverter.toX(graphicNode.getStart());
        double d2 = coordinatesConverter.toX(graphicNode.getEnd());
        d2 = CoordinatesConverter.adaptSmallBarEndX(d, d2, graphicNode, this.config);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset(), d2 - d, graphicNode.getGanttShapeHeight());
        return double_;
    }

    public CoordinatesConverter getCoord() {
        return ((GanttUI)this.ui).getCoord();
    }

    protected void setLinkOrigin() {
        GraphicNode graphicNode = (GraphicNode)this.selected;
        CoordinatesConverter coordinatesConverter = this.getCoord();
        double d = coordinatesConverter.toX(this.selectedIntervalNumber == 0 ? (double)graphicNode.getStart() : (double)this.selectedInterval.getStart());
        double d2 = this.selectedIntervalNumber == 0 ? CoordinatesConverter.adaptSmallBarEndX(coordinatesConverter.toX(graphicNode.getStart()), coordinatesConverter.toX(graphicNode.getEnd()), graphicNode, this.config) : coordinatesConverter.toX(this.selectedInterval.getEnd());
        this.x0link = (d + d2) / 2.0;
        this.y0link = ((GanttUI)this.ui).getBarY(graphicNode.getRow()) + graphicNode.getGanttShapeOffset() + graphicNode.getGanttShapeHeight() / 2.0;
    }

    protected boolean allowLinkSelectionToMove() {
        return this.beforeLinkState == 3 || this.beforeLinkState == 4 || this.beforeLinkState == 5;
    }

    protected boolean switchOnLinkCreation(double d, double d2) {
        if (this.state == 6) {
            return false;
        }
        GraphicNode graphicNode = (GraphicNode)this.selected;
        Object object = graphicNode.getNode().getImpl();
        return object instanceof HasDependencies && (int)d2 / ((Gantt)this.getGraph()).getRowHeight() != graphicNode.getRow();
    }

    public Cursor selectCursor() {
        Cursor cursor = null;
        switch (this.state) {
            case 4: {
                cursor = new Cursor(10);
                break;
            }
            case 5: {
                cursor = new Cursor(11);
                break;
            }
            case 6: {
                cursor = this.getProgressCursor();
                break;
            }
            case 7: {
                cursor = this.getSplitCursor();
            }
        }
        if (cursor == null) {
            super.selectCursor();
        } else {
            this.getGraph().setCursor(cursor);
        }
        return cursor;
    }

    public boolean executeAction(double d, double d2) {
        if (d == this.x0 || this.selected == null) {
            return false;
        }
        if (this.state == 3 || this.state == 4 || this.state == 5 || this.state == 6 || this.state == 7) {
            if (!(this.selected instanceof GraphicNode)) {
                return false;
            }
            this.sourceNode = (GraphicNode)this.selected;
        }
        long l = (long)this.getCoord().toTime(d);
        long l2 = (long)this.getCoord().toDuration(d - this.x0);
        switch (this.state) {
            case 3: {
                ScheduleService.getInstance().setInterval(this, (Schedule)this.sourceNode.getNode().getImpl(), this.selectedInterval.getStart() + l2, this.selectedInterval.getEnd() + l2, this.selectedInterval, this.ui.getGraph().getProject().getUndoController().getEditSupport());
                return true;
            }
            case 4: {
                ScheduleService.getInstance().setInterval(this, (Schedule)this.sourceNode.getNode().getImpl(), this.selectedInterval.getStart() + l2, this.selectedInterval.getEnd(), this.selectedInterval, this.ui.getGraph().getProject().getUndoController().getEditSupport());
                return true;
            }
            case 5: {
                ScheduleService.getInstance().setInterval(this, (Schedule)this.sourceNode.getNode().getImpl(), this.selectedInterval.getStart(), this.selectedInterval.getEnd() + l2, this.selectedInterval, this.ui.getGraph().getProject().getUndoController().getEditSupport());
                return true;
            }
            case 6: {
                ScheduleService.getInstance().setCompleted(this, (Schedule)this.sourceNode.getNode().getImpl(), l, this.ui.getGraph().getProject().getUndoController().getEditSupport());
                return true;
            }
            case 1: {
                try {
                    if (this.sourceNode != null && this.destinationNode != null && this.sourceNode.getNode().getImpl() instanceof HasDependencies && this.destinationNode.getNode().getImpl() instanceof HasDependencies && !ClassUtils.isObjectReadOnly(this.destinationNode.getNode().getImpl())) {
                        DependencyService.getInstance().newDependency((HasDependencies)this.sourceNode.getNode().getImpl(), (HasDependencies)this.destinationNode.getNode().getImpl(), 1, 0L, this);
                    }
                }
                catch (InvalidAssociationException invalidAssociationException) {
                    Alert.error(invalidAssociationException.getMessage());
                }
                return true;
            }
            case 2: {
                this.showDependencyPropertiesDialog((GraphicDependency)this.selected);
                return true;
            }
            case 7: {
                ScheduleService.getInstance().split(this, (Schedule)this.sourceNode.getNode().getImpl(), l, l, this.ui.getGraph().getProject().getUndoController().getEditSupport());
                return true;
            }
        }
        return false;
    }

    public void setSplitMode() {
        this.state = 7;
        this.selectCursor();
    }

    protected void select(int n, int n2) {
        if (this.selection) {
            this.selectedZone = this.ui.getObjectAt(n, n2);
            Object object = this.selected = this.selectedZone == null ? null : this.selectedZone.getObject();
            if (this.state == 7) {
                return;
            }
            if (this.selected == null) {
                this.state = 0;
            } else {
                this.findState(n, n2);
            }
            this.selectCursor();
        }
    }

    protected boolean isMove() {
        return this.state == 3 || this.state == 5 || this.state == 4 || this.state == 6;
    }

    protected boolean isDirectAction() {
        return this.state == 7 || super.isDirectAction();
    }

    protected boolean isRepaintOnRelease() {
        return this.state == 3 || this.state == 5 || this.state == 4 || this.state == 6 || this.state == 1;
    }

    private class NodeSelectionIntervalConsumer
    implements IntervalConsumer {
        private boolean consumed = false;
        private GraphicNode node;
        private double deltaResize0;
        private double deltaResize1;
        private double deltaOutside;
        private double completedDeltaT0;
        private double completedDeltaT1;
        private ScheduleInterval completedInterval;
        private double t;
        private CoordinatesConverter coord;

        private NodeSelectionIntervalConsumer() {
        }

        public NodeSelectionIntervalConsumer init(double d, GraphicNode graphicNode) {
            this.t = GanttInteractor.this.getCoord().toTime(d);
            this.consumed = false;
            GanttInteractor.this.selectedInterval = null;
            this.completedInterval = null;
            GanttInteractor.this.selectedIntervalNumber = 0;
            this.coord = GanttInteractor.this.getCoord();
            this.completedDeltaT0 = this.coord.toDuration(GanttInteractor.this.config.getSelectionProgress0());
            this.completedDeltaT1 = this.coord.toDuration(GanttInteractor.this.config.getSelectionProgress1());
            this.deltaResize0 = this.coord.toDuration(GanttInteractor.this.config.getSelectionResize0());
            this.deltaResize1 = this.coord.toDuration(GanttInteractor.this.config.getSelectionResize1());
            this.deltaOutside = this.coord.toDuration(GanttInteractor.this.config.getSelectionSquare());
            this.node = graphicNode;
            return this;
        }

        public void consumeInterval(ScheduleInterval scheduleInterval) {
            if (this.consumed) {
                return;
            }
            if (ClassUtils.isObjectReadOnly(((GraphicNode)GanttInteractor.this.selected).getNode().getImpl())) {
                return;
            }
            if (this.coord != null) {
                long l = ((GraphicNode)GanttInteractor.this.selected).getCompleted();
                if (l >= scheduleInterval.getStart() && l <= scheduleInterval.getEnd()) {
                    this.completedInterval = new ScheduleInterval(scheduleInterval.getStart(), l);
                    if (scheduleInterval.getEnd() > scheduleInterval.getStart()) {
                        this.completedInterval = this.coord.adaptSmallBarTimeInterval(this.completedInterval, this.node, GanttInteractor.this.config);
                    }
                }
                scheduleInterval = this.coord.adaptSmallBarTimeInterval(scheduleInterval, this.node, GanttInteractor.this.config);
            }
            if (this.t < (double)scheduleInterval.getStart() && this.t >= (double)scheduleInterval.getStart() - this.deltaOutside) {
                if (GanttInteractor.this.selectedIsNonSummaryNode()) {
                    GanttInteractor.this.state = 4;
                }
            } else if (this.t > (double)scheduleInterval.getEnd() && this.t <= (double)scheduleInterval.getEnd() + this.deltaOutside) {
                if (GanttInteractor.this.selectedIsNonSummaryNode()) {
                    GanttInteractor.this.state = 5;
                }
            } else {
                if (this.t < (double)scheduleInterval.getStart() || this.t > (double)scheduleInterval.getEnd()) {
                    ++GanttInteractor.this.selectedIntervalNumber;
                    return;
                }
                if (this.completedInterval != null && this.t >= (double)this.completedInterval.getEnd() - this.completedDeltaT0 && this.t <= (double)this.completedInterval.getEnd() + this.completedDeltaT1 && GanttInteractor.this.selectedZone != null && GanttInteractor.this.selectedZone.getZoneId() == 1) {
                    if (GanttInteractor.this.selectedIsNonSummaryNode()) {
                        GanttInteractor.this.state = 6;
                    }
                } else if (this.t <= (double)scheduleInterval.getStart() + this.deltaResize0) {
                    if (GanttInteractor.this.selectedIsNonSummaryNode()) {
                        GanttInteractor.this.state = 4;
                    }
                } else if (this.t >= (double)scheduleInterval.getEnd() - this.deltaResize1) {
                    if (GanttInteractor.this.selectedIsNonSummaryNode()) {
                        GanttInteractor.this.state = 5;
                    }
                } else {
                    GanttInteractor.this.state = 3;
                }
            }
            GanttInteractor.this.selectedInterval = scheduleInterval;
            this.consumed = true;
        }
    }
}

