/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileVersion;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.InputStreamTokenizer;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ReaderTokenizer;
import net.sf.mpxj.common.Tokenizer;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpx.ConstraintTypeUtility;
import net.sf.mpxj.mpx.DurationUtility;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXJFormats;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.PriorityUtility;
import net.sf.mpxj.mpx.Record;
import net.sf.mpxj.mpx.RecurrenceUtility;
import net.sf.mpxj.mpx.RelationTypeUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class MPXReader
extends AbstractProjectReader {
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_ignoreTextModels = true;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private ProjectConfig m_projectConfig;
    private Task m_lastTask;
    private Resource m_lastResource;
    private ProjectCalendar m_lastResourceCalendar;
    private ResourceAssignment m_lastResourceAssignment;
    private ProjectCalendar m_lastBaseCalendar;
    private boolean m_resourceTableDefinition;
    private boolean m_taskTableDefinition;
    private TaskModel m_taskModel;
    private ResourceModel m_resourceModel;
    private char m_delimiter;
    private MPXJFormats m_formats;
    private List<DeferredRelationship> m_deferredRelationships;
    private List<ProjectListener> m_projectListeners;
    private int m_baseOutlineLevel;

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public ProjectFile read(InputStream inputStream) throws MPXJException {
        int n = 1;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[4];
            byArray[0] = (byte)bufferedInputStream.read();
            bufferedInputStream.mark(1024);
            byArray[1] = (byte)bufferedInputStream.read();
            byArray[2] = (byte)bufferedInputStream.read();
            byArray[3] = (byte)bufferedInputStream.read();
            if (byArray[0] != 77 || byArray[1] != 80 || byArray[2] != 88) {
                throw new MPXJException("Invalid file format");
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_projectConfig = this.m_projectFile.getProjectConfig();
            this.m_projectConfig.setAutoTaskID(false);
            this.m_projectConfig.setAutoTaskUniqueID(false);
            this.m_projectConfig.setAutoResourceID(false);
            this.m_projectConfig.setAutoResourceUniqueID(false);
            this.m_projectConfig.setAutoOutlineLevel(false);
            this.m_projectConfig.setAutoOutlineNumber(false);
            this.m_projectConfig.setAutoWBS(false);
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            LocaleUtility.setLocale(this.m_projectFile.getProjectProperties(), this.m_locale);
            this.m_delimiter = (char)byArray[3];
            this.m_projectFile.getProjectProperties().setMpxDelimiter(this.m_delimiter);
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_taskModel.setLocale(this.m_locale);
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_resourceModel.setLocale(this.m_locale);
            this.m_baseOutlineLevel = -1;
            this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
            this.m_deferredRelationships = new LinkedList<DeferredRelationship>();
            bufferedInputStream.reset();
            Tokenizer tokenizer = new InputStreamTokenizer(bufferedInputStream);
            tokenizer.setDelimiter(this.m_delimiter);
            this.parseRecord(Integer.toString(999), new Record(this.m_locale, tokenizer, this.m_formats));
            ++n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, this.m_projectFile.getProjectProperties().getMpxCodePage().getCharset());
            tokenizer = new ReaderTokenizer(inputStreamReader);
            tokenizer.setDelimiter(this.m_delimiter);
            while (tokenizer.getType() != -1) {
                Record record = new Record(this.m_locale, tokenizer, this.m_formats);
                String string = record.getRecordNumber();
                if (string != null) {
                    this.parseRecord(string, record);
                }
                ++n;
            }
            this.processDeferredRelationships();
            this.m_projectFile.updateStructure();
            this.m_projectConfig.updateUniqueCounters();
            this.m_projectConfig.setAutoCalendarUniqueID(false);
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (Exception exception) {
            throw new MPXJException("Error reading file (failed at line " + n + ")", exception);
        }
        finally {
            this.m_projectFile = null;
            this.m_lastTask = null;
            this.m_lastResource = null;
            this.m_lastResourceCalendar = null;
            this.m_lastResourceAssignment = null;
            this.m_lastBaseCalendar = null;
            this.m_resourceTableDefinition = false;
            this.m_taskTableDefinition = false;
            this.m_taskModel = null;
            this.m_resourceModel = null;
            this.m_formats = null;
            this.m_deferredRelationships = null;
        }
    }

    private void parseRecord(String string, Record record) throws MPXJException {
        switch (Integer.parseInt(string)) {
            case 0: 
            case 80: 
            case 81: {
                break;
            }
            case 10: {
                this.populateCurrencySettings(record, this.m_projectFile.getProjectProperties());
                this.m_formats.update();
                break;
            }
            case 11: {
                this.populateDefaultSettings(record, this.m_projectFile.getProjectProperties());
                this.m_formats.update();
                break;
            }
            case 12: {
                this.populateDateTimeSettings(record, this.m_projectFile.getProjectProperties());
                this.m_formats.update();
                break;
            }
            case 20: {
                this.m_lastBaseCalendar = this.m_projectFile.addCalendar();
                this.populateCalendar(record, this.m_lastBaseCalendar, true);
                break;
            }
            case 25: {
                if (this.m_lastBaseCalendar == null) break;
                ProjectCalendarHours projectCalendarHours = this.m_lastBaseCalendar.addCalendarHours();
                this.populateCalendarHours(record, projectCalendarHours);
                break;
            }
            case 26: {
                if (this.m_lastBaseCalendar == null) break;
                this.populateCalendarException(record, this.m_lastBaseCalendar);
                break;
            }
            case 30: {
                this.populateProjectHeader(record, this.m_projectFile.getProjectProperties());
                this.m_formats.update();
                break;
            }
            case 40: {
                if (this.m_resourceTableDefinition || this.m_ignoreTextModels) break;
                this.m_resourceModel.update(record, true);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 41: {
                if (this.m_resourceTableDefinition) break;
                this.m_resourceModel.update(record, false);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 50: {
                this.m_lastResource = this.m_projectFile.addResource();
                this.populateResource(this.m_lastResource, record);
                this.m_eventManager.fireResourceReadEvent(this.m_lastResource);
                break;
            }
            case 51: {
                if (this.m_lastResource == null) break;
                this.m_lastResource.setNotes(record.getString(0));
                break;
            }
            case 55: {
                if (this.m_lastResource == null) break;
                this.m_lastResourceCalendar = this.m_lastResource.addResourceCalendar();
                this.populateCalendar(record, this.m_lastResourceCalendar, false);
                break;
            }
            case 56: {
                if (this.m_lastResourceCalendar == null) break;
                ProjectCalendarHours projectCalendarHours = this.m_lastResourceCalendar.addCalendarHours();
                this.populateCalendarHours(record, projectCalendarHours);
                break;
            }
            case 57: {
                if (this.m_lastResourceCalendar == null) break;
                this.populateCalendarException(record, this.m_lastResourceCalendar);
                break;
            }
            case 60: {
                if (this.m_taskTableDefinition || this.m_ignoreTextModels) break;
                this.m_taskModel.update(record, true);
                this.m_taskTableDefinition = true;
                break;
            }
            case 61: {
                if (this.m_taskTableDefinition) break;
                this.m_taskModel.update(record, false);
                this.m_taskTableDefinition = true;
                break;
            }
            case 70: {
                this.m_lastTask = this.m_projectFile.addTask();
                this.populateTask(record, this.m_lastTask);
                int n = NumberHelper.getInt(this.m_lastTask.getOutlineLevel());
                if (this.m_baseOutlineLevel == -1) {
                    this.m_baseOutlineLevel = n;
                }
                if (n != this.m_baseOutlineLevel) {
                    List<Task> list = this.m_projectFile.getChildTasks();
                    if (list.isEmpty()) {
                        throw new MPXJException("Invalid outline level");
                    }
                    list.get(list.size() - 1).addChildTask(this.m_lastTask, n);
                }
                this.m_eventManager.fireTaskReadEvent(this.m_lastTask);
                break;
            }
            case 71: {
                if (this.m_lastTask == null) break;
                this.m_lastTask.setNotes(record.getString(0));
                break;
            }
            case 72: {
                if (this.m_lastTask == null) break;
                this.m_lastTask.setRecurring(true);
                RecurringTask recurringTask = this.m_lastTask.addRecurringTask();
                this.populateRecurringTask(record, recurringTask);
                break;
            }
            case 75: {
                if (this.m_lastTask == null) break;
                this.m_lastResourceAssignment = this.m_lastTask.addResourceAssignment((Resource)null);
                this.populateResourceAssignment(record, this.m_lastResourceAssignment);
                break;
            }
            case 76: {
                if (this.m_lastResourceAssignment == null) break;
                ResourceAssignmentWorkgroupFields resourceAssignmentWorkgroupFields = this.m_lastResourceAssignment.addWorkgroupAssignment();
                this.populateResourceAssignmentWorkgroupFields(record, resourceAssignmentWorkgroupFields);
                break;
            }
            case 999: {
                MPXReader.populateFileCreationRecord(record, this.m_projectFile.getProjectProperties());
                break;
            }
            default: {
                throw new MPXJException("Invalid record");
            }
        }
    }

    private void populateCurrencySettings(Record record, ProjectProperties projectProperties) {
        projectProperties.setCurrencySymbol(record.getString(0));
        projectProperties.setSymbolPosition(record.getCurrencySymbolPosition(1));
        projectProperties.setCurrencyDigits(record.getInteger(2));
        Character c = record.getCharacter(3);
        if (c != null) {
            projectProperties.setThousandsSeparator(c.charValue());
        }
        if ((c = record.getCharacter(4)) != null) {
            projectProperties.setDecimalSeparator(c.charValue());
        }
    }

    private void populateDefaultSettings(Record record, ProjectProperties projectProperties) throws MPXJException {
        projectProperties.setDefaultDurationUnits(record.getTimeUnit(0));
        projectProperties.setDefaultDurationIsFixed(record.getNumericBoolean(1));
        projectProperties.setDefaultWorkUnits(record.getTimeUnit(2));
        projectProperties.setMinutesPerDay(NumberHelper.getDouble(record.getFloat(3)) * 60.0);
        projectProperties.setMinutesPerWeek(NumberHelper.getDouble(record.getFloat(4)) * 60.0);
        projectProperties.setDefaultStandardRate(record.getRate(5));
        projectProperties.setDefaultOvertimeRate(record.getRate(6));
        projectProperties.setUpdatingTaskStatusUpdatesResourceStatus(record.getNumericBoolean(7));
        projectProperties.setSplitInProgressTasks(record.getNumericBoolean(8));
    }

    private void populateDateTimeSettings(Record record, ProjectProperties projectProperties) {
        Character c;
        projectProperties.setDateOrder(record.getDateOrder(0));
        projectProperties.setTimeFormat(record.getTimeFormat(1));
        Date date = this.getTimeFromInteger(record.getInteger(2));
        if (date != null) {
            projectProperties.setDefaultStartTime(date);
        }
        if ((c = record.getCharacter(3)) != null) {
            projectProperties.setDateSeparator(c.charValue());
        }
        if ((c = record.getCharacter(4)) != null) {
            projectProperties.setTimeSeparator(c.charValue());
        }
        projectProperties.setAMText(record.getString(5));
        projectProperties.setPMText(record.getString(6));
        projectProperties.setDateFormat(record.getDateFormat(7));
        projectProperties.setBarTextDateFormat(record.getDateFormat(8));
    }

    private Date getTimeFromInteger(Integer n) {
        Date date = null;
        if (n != null) {
            int n2 = n;
            int n3 = n2 / 60;
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, n2 -= n3 * 60);
            calendar.set(11, n3);
            date = calendar.getTime();
        }
        return date;
    }

    private void populateProjectHeader(Record record, ProjectProperties projectProperties) throws MPXJException {
        projectProperties.setProjectTitle(record.getString(0));
        projectProperties.setCompany(record.getString(1));
        projectProperties.setManager(record.getString(2));
        projectProperties.setDefaultCalendarName(record.getString(3));
        projectProperties.setStartDate(record.getDateTime(4));
        projectProperties.setFinishDate(record.getDateTime(5));
        projectProperties.setScheduleFrom(record.getScheduleFrom(6));
        projectProperties.setCurrentDate(record.getDateTime(7));
        projectProperties.setComments(record.getString(8));
        projectProperties.setCost(record.getCurrency(9));
        projectProperties.setBaselineCost(record.getCurrency(10));
        projectProperties.setActualCost(record.getCurrency(11));
        projectProperties.setWork(record.getDuration(12));
        projectProperties.setBaselineWork(record.getDuration(13));
        projectProperties.setActualWork(record.getDuration(14));
        projectProperties.setWork2(record.getPercentage(15));
        projectProperties.setDuration(record.getDuration(16));
        projectProperties.setBaselineDuration(record.getDuration(17));
        projectProperties.setActualDuration(record.getDuration(18));
        projectProperties.setPercentageComplete(record.getPercentage(19));
        projectProperties.setBaselineStart(record.getDateTime(20));
        projectProperties.setBaselineFinish(record.getDateTime(21));
        projectProperties.setActualStart(record.getDateTime(22));
        projectProperties.setActualFinish(record.getDateTime(23));
        projectProperties.setStartVariance(record.getDuration(24));
        projectProperties.setFinishVariance(record.getDuration(25));
        projectProperties.setSubject(record.getString(26));
        projectProperties.setAuthor(record.getString(27));
        projectProperties.setKeywords(record.getString(28));
    }

    private void populateCalendarHours(Record record, ProjectCalendarHours projectCalendarHours) throws MPXJException {
        projectCalendarHours.setDay(Day.getInstance(NumberHelper.getInt(record.getInteger(0))));
        this.addDateRange(projectCalendarHours, record.getTime(1), record.getTime(2));
        this.addDateRange(projectCalendarHours, record.getTime(3), record.getTime(4));
        this.addDateRange(projectCalendarHours, record.getTime(5), record.getTime(6));
    }

    private void addDateRange(ProjectCalendarHours projectCalendarHours, Date date, Date date2) {
        if (date != null && date2 != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
                calendar.add(6, 1);
            }
            date2 = calendar.getTime();
            projectCalendarHours.addRange(new DateRange(date, date2));
        }
    }

    private void populateCalendarException(Record record, ProjectCalendar projectCalendar) throws MPXJException {
        Date date = record.getDate(0);
        Date date2 = record.getDate(1);
        boolean bl = record.getNumericBoolean(2);
        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
        if (bl) {
            projectCalendarException.addRange(new DateRange(record.getTime(3), record.getTime(4)));
            projectCalendarException.addRange(new DateRange(record.getTime(5), record.getTime(6)));
            projectCalendarException.addRange(new DateRange(record.getTime(7), record.getTime(8)));
        }
    }

    private void populateCalendar(Record record, ProjectCalendar projectCalendar, boolean bl) {
        if (bl) {
            projectCalendar.setName(record.getString(0));
        } else {
            projectCalendar.setParent(this.m_projectFile.getCalendarByName(record.getString(0)));
        }
        projectCalendar.setWorkingDay(Day.SUNDAY, DayType.getInstance(record.getInteger(1)));
        projectCalendar.setWorkingDay(Day.MONDAY, DayType.getInstance(record.getInteger(2)));
        projectCalendar.setWorkingDay(Day.TUESDAY, DayType.getInstance(record.getInteger(3)));
        projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.getInstance(record.getInteger(4)));
        projectCalendar.setWorkingDay(Day.THURSDAY, DayType.getInstance(record.getInteger(5)));
        projectCalendar.setWorkingDay(Day.FRIDAY, DayType.getInstance(record.getInteger(6)));
        projectCalendar.setWorkingDay(Day.SATURDAY, DayType.getInstance(record.getInteger(7)));
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private void populateResource(Resource resource, Record record) throws MPXJException {
        int n;
        String string = LocaleData.getString(this.m_locale, "NO");
        int n2 = record.getLength();
        int[] nArray = this.m_resourceModel.getModel();
        block12: for (int i = 0; i < n2 && (n = nArray[i]) != -1; ++i) {
            String string2 = record.getString(i);
            if (string2 == null || string2.length() == 0) continue;
            ResourceField resourceField = MPXResourceField.getMpxjField(n);
            switch (resourceField) {
                case OBJECTS: {
                    resource.set((FieldType)resourceField, record.getInteger(i));
                    continue block12;
                }
                case ID: {
                    resource.setID(record.getInteger(i));
                    continue block12;
                }
                case UNIQUE_ID: {
                    resource.setUniqueID(record.getInteger(i));
                    continue block12;
                }
                case MAX_UNITS: {
                    resource.set((FieldType)resourceField, record.getUnits(i));
                    continue block12;
                }
                case PERCENT_WORK_COMPLETE: 
                case PEAK: {
                    resource.set((FieldType)resourceField, record.getPercentage(i));
                    continue block12;
                }
                case COST: 
                case COST_PER_USE: 
                case COST_VARIANCE: 
                case BASELINE_COST: 
                case ACTUAL_COST: 
                case REMAINING_COST: {
                    resource.set((FieldType)resourceField, record.getCurrency(i));
                    continue block12;
                }
                case OVERTIME_RATE: 
                case STANDARD_RATE: {
                    resource.set((FieldType)resourceField, record.getRate(i));
                    continue block12;
                }
                case REMAINING_WORK: 
                case OVERTIME_WORK: 
                case BASELINE_WORK: 
                case ACTUAL_WORK: 
                case WORK: 
                case WORK_VARIANCE: {
                    resource.set((FieldType)resourceField, record.getDuration(i));
                    continue block12;
                }
                case ACCRUE_AT: {
                    resource.set((FieldType)resourceField, record.getAccrueType(i));
                    continue block12;
                }
                case LINKED_FIELDS: 
                case OVERALLOCATED: {
                    resource.set((FieldType)resourceField, record.getBoolean(i, string));
                    continue block12;
                }
                default: {
                    resource.set((FieldType)resourceField, string2);
                }
            }
        }
        if (this.m_projectConfig.getAutoResourceUniqueID()) {
            resource.setUniqueID(this.m_projectConfig.getNextResourceUniqueID());
        }
        if (this.m_projectConfig.getAutoResourceID()) {
            resource.setID(this.m_projectConfig.getNextResourceID());
        }
        if (resource.getUniqueID() == null) {
            resource.setUniqueID(resource.getID());
        }
    }

    private void populateRelationList(Task task, TaskField taskField, String string) {
        DeferredRelationship deferredRelationship = new DeferredRelationship();
        deferredRelationship.setTask(task);
        deferredRelationship.setField(taskField);
        deferredRelationship.setData(string);
        this.m_deferredRelationships.add(deferredRelationship);
    }

    private void processDeferredRelationships() throws MPXJException {
        for (DeferredRelationship deferredRelationship : this.m_deferredRelationships) {
            this.processDeferredRelationship(deferredRelationship);
        }
    }

    private void processDeferredRelationship(DeferredRelationship deferredRelationship) throws MPXJException {
        String string = deferredRelationship.getData();
        Task task = deferredRelationship.getTask();
        int n = string.length();
        if (n != 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 != n) {
                n3 = string.indexOf(this.m_delimiter, n2);
                if (n3 == -1) {
                    n3 = n;
                }
                this.populateRelation(deferredRelationship.getField(), task, string.substring(n2, n3).trim());
                n2 = n3 + 1;
            }
        }
    }

    private void populateRelation(TaskField taskField, Task task, String string) throws MPXJException {
        Integer n;
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isDigit(string.charAt(n2)); ++n2) {
        }
        try {
            n = Integer.valueOf(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MPXJException("Invalid format '" + string + "'");
        }
        Task task2 = taskField == TaskField.PREDECESSORS ? this.m_projectFile.getTaskByID(n) : this.m_projectFile.getTaskByUniqueID(n);
        RelationType relationType = null;
        Duration duration = null;
        if (n2 == n3) {
            relationType = RelationType.FINISH_START;
            duration = Duration.getInstance(0, TimeUnit.DAYS);
        } else {
            if (n2 + 1 == n3) {
                throw new MPXJException("Invalid format '" + string + "'");
            }
            relationType = RelationTypeUtility.getInstance(this.m_locale, string.substring(n2, n2 + 2));
            if ((n2 += 2) == n3) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            } else {
                if (string.charAt(n2) == '+') {
                    ++n2;
                }
                duration = DurationUtility.getInstance(string.substring(n2), this.m_formats.getDurationDecimalFormat(), this.m_locale);
            }
        }
        if (relationType == null) {
            throw new MPXJException("Invalid format '" + string + "'");
        }
        Relation relation = task.addPredecessor(task2, relationType, duration);
        this.m_eventManager.fireRelationReadEvent(relation);
    }

    private void populateTask(Record record, Task task) throws MPXJException {
        String string = LocaleData.getString(this.m_locale, "NO");
        int n = 0;
        int n2 = 0;
        int n3 = record.getLength();
        int[] nArray = this.m_taskModel.getModel();
        block23: while (n2 < n3 && (n = nArray[n2]) != -1) {
            String string2;
            if ((string2 = record.getString(n2++)) == null || string2.length() == 0) continue;
            TaskField taskField = MPXTaskField.getMpxjField(n);
            if (taskField == null) {
                System.out.println("Null Task Field " + n);
                continue;
            }
            switch (taskField) {
                case PREDECESSORS: 
                case UNIQUE_ID_PREDECESSORS: {
                    this.populateRelationList(task, taskField, string2);
                    continue block23;
                }
                case PERCENT_COMPLETE: 
                case PERCENT_WORK_COMPLETE: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getPercentageDecimalFormat().parse(string2));
                        continue block23;
                    }
                    catch (ParseException parseException) {
                        throw new MPXJException("Failed to parse percentage", parseException);
                    }
                }
                case ACTUAL_COST: 
                case BASELINE_COST: 
                case BCWP: 
                case BCWS: 
                case COST: 
                case COST1: 
                case COST2: 
                case COST3: 
                case COST_VARIANCE: 
                case CV: 
                case FIXED_COST: 
                case REMAINING_COST: 
                case SV: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getCurrencyFormat().parse(string2));
                        continue block23;
                    }
                    catch (ParseException parseException) {
                        throw new MPXJException("Failed to parse currency", parseException);
                    }
                }
                case ACTUAL_DURATION: 
                case ACTUAL_WORK: 
                case BASELINE_DURATION: 
                case BASELINE_WORK: 
                case DURATION: 
                case DURATION1: 
                case DURATION2: 
                case DURATION3: 
                case DURATION_VARIANCE: 
                case FINISH_VARIANCE: 
                case FREE_SLACK: 
                case REMAINING_DURATION: 
                case REMAINING_WORK: 
                case START_VARIANCE: 
                case TOTAL_SLACK: 
                case WORK: 
                case WORK_VARIANCE: 
                case LEVELING_DELAY: {
                    task.set((FieldType)taskField, DurationUtility.getInstance(string2, this.m_formats.getDurationDecimalFormat(), this.m_locale));
                    continue block23;
                }
                case ACTUAL_FINISH: 
                case ACTUAL_START: 
                case BASELINE_FINISH: 
                case BASELINE_START: 
                case CONSTRAINT_DATE: 
                case CREATED: 
                case EARLY_FINISH: 
                case EARLY_START: 
                case FINISH: 
                case FINISH1: 
                case FINISH2: 
                case FINISH3: 
                case FINISH4: 
                case FINISH5: 
                case LATE_FINISH: 
                case LATE_START: 
                case RESUME: 
                case START: 
                case START1: 
                case START2: 
                case START3: 
                case START4: 
                case START5: 
                case STOP: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDateTimeFormat().parse(string2));
                        continue block23;
                    }
                    catch (ParseException parseException) {
                        throw new MPXJException("Failed to parse date time", parseException);
                    }
                }
                case CONFIRMED: 
                case CRITICAL: 
                case FLAG1: 
                case FLAG2: 
                case FLAG3: 
                case FLAG4: 
                case FLAG5: 
                case FLAG6: 
                case FLAG7: 
                case FLAG8: 
                case FLAG9: 
                case FLAG10: 
                case HIDE_BAR: 
                case LINKED_FIELDS: 
                case MARKED: 
                case MILESTONE: 
                case ROLLUP: 
                case SUMMARY: 
                case UPDATE_NEEDED: {
                    task.set((FieldType)taskField, string2.equalsIgnoreCase(string) ? Boolean.FALSE : Boolean.TRUE);
                    continue block23;
                }
                case CONSTRAINT_TYPE: {
                    task.set((FieldType)taskField, ConstraintTypeUtility.getInstance(this.m_locale, string2));
                    continue block23;
                }
                case OBJECTS: 
                case OUTLINE_LEVEL: {
                    task.set((FieldType)taskField, Integer.valueOf(string2));
                    continue block23;
                }
                case ID: {
                    task.setID(Integer.valueOf(string2));
                    continue block23;
                }
                case UNIQUE_ID: {
                    task.setUniqueID(Integer.valueOf(string2));
                    continue block23;
                }
                case NUMBER1: 
                case NUMBER2: 
                case NUMBER3: 
                case NUMBER4: 
                case NUMBER5: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDecimalFormat().parse(string2));
                        continue block23;
                    }
                    catch (ParseException parseException) {
                        throw new MPXJException("Failed to parse number", parseException);
                    }
                }
                case PRIORITY: {
                    task.set((FieldType)taskField, PriorityUtility.getInstance(this.m_locale, string2));
                    continue block23;
                }
                case TYPE: {
                    boolean bl = !string2.equalsIgnoreCase(string);
                    task.setType(bl ? TaskType.FIXED_DURATION : TaskType.FIXED_UNITS);
                    continue block23;
                }
            }
            task.set((FieldType)taskField, string2);
        }
        if (this.m_projectConfig.getAutoWBS()) {
            task.generateWBS(null);
        }
        if (this.m_projectConfig.getAutoOutlineNumber()) {
            task.generateOutlineNumber(null);
        }
        if (this.m_projectConfig.getAutoOutlineLevel()) {
            task.setOutlineLevel(1);
        }
        if (this.m_projectConfig.getAutoTaskUniqueID()) {
            task.setUniqueID(this.m_projectConfig.getNextTaskUniqueID());
        }
        if (task.getID() == null || this.m_projectConfig.getAutoTaskID()) {
            task.setID(this.m_projectConfig.getNextTaskID());
        }
        if (task.getUniqueID() == null) {
            task.setUniqueID(task.getID());
        }
        if (task.getStart() == null && task.getEarlyStart() != null) {
            task.setStart(task.getEarlyStart());
        }
        if (task.getFinish() == null && task.getEarlyFinish() != null) {
            task.setFinish(task.getEarlyFinish());
        }
    }

    private void populateRecurringTask(Record record, RecurringTask recurringTask) throws MPXJException {
        recurringTask.setStartDate(record.getDateTime(1));
        recurringTask.setFinishDate(record.getDateTime(2));
        recurringTask.setDuration(RecurrenceUtility.getDuration(this.m_projectFile.getProjectProperties(), record.getInteger(3), record.getInteger(4)));
        recurringTask.setOccurrences(record.getInteger(5));
        recurringTask.setRecurrenceType(RecurrenceUtility.getRecurrenceType(record.getInteger(6)));
        recurringTask.setUseEndDate(NumberHelper.getInt(record.getInteger(8)) == 1);
        recurringTask.setDailyWorkday(NumberHelper.getInt(record.getInteger(9)) == 1);
        recurringTask.setWeeklyDays(RecurrenceUtility.getDays(record.getString(10)));
        recurringTask.setMonthlyRelative(NumberHelper.getInt(record.getInteger(11)) == 1);
        recurringTask.setYearlyAbsolute(NumberHelper.getInt(record.getInteger(12)) == 1);
        recurringTask.setDailyFrequency(record.getInteger(13));
        recurringTask.setWeeklyFrequency(record.getInteger(14));
        recurringTask.setMonthlyRelativeOrdinal(record.getInteger(15));
        recurringTask.setMonthlyRelativeDay(RecurrenceUtility.getDay(record.getInteger(16)));
        recurringTask.setMonthlyRelativeFrequency(record.getInteger(17));
        recurringTask.setMonthlyAbsoluteDay(record.getInteger(18));
        recurringTask.setMonthlyAbsoluteFrequency(record.getInteger(19));
        recurringTask.setYearlyRelativeOrdinal(record.getInteger(20));
        recurringTask.setYearlyRelativeDay(RecurrenceUtility.getDay(record.getInteger(21)));
        recurringTask.setYearlyRelativeMonth(record.getInteger(22));
        recurringTask.setYearlyAbsoluteDate(record.getDateTime(23));
    }

    private void populateResourceAssignment(Record record, ResourceAssignment resourceAssignment) throws MPXJException {
        Resource resource = this.m_projectFile.getResourceByUniqueID(record.getInteger(12));
        if (resource == null) {
            resource = this.m_projectFile.getResourceByID(record.getInteger(0));
        }
        resourceAssignment.setUnits(record.getUnits(1));
        resourceAssignment.setWork(record.getDuration(2));
        resourceAssignment.setBaselineWork(record.getDuration(3));
        resourceAssignment.setActualWork(record.getDuration(4));
        resourceAssignment.setOvertimeWork(record.getDuration(5));
        resourceAssignment.setCost(record.getCurrency(6));
        resourceAssignment.setBaselineCost(record.getCurrency(7));
        resourceAssignment.setActualCost(record.getCurrency(8));
        resourceAssignment.setStart(record.getDateTime(9));
        resourceAssignment.setFinish(record.getDateTime(10));
        resourceAssignment.setDelay(record.getDuration(11));
        Duration duration = resourceAssignment.getWork();
        Duration duration2 = resourceAssignment.getActualWork();
        if (duration != null && duration2 != null) {
            if (duration.getUnits() != duration2.getUnits()) {
                duration2 = duration2.convertUnits(duration.getUnits(), this.m_projectFile.getProjectProperties());
            }
            resourceAssignment.setRemainingWork(Duration.getInstance(duration.getDuration() - duration2.getDuration(), duration.getUnits()));
        }
        if (resource != null) {
            resourceAssignment.setResourceUniqueID(resource.getUniqueID());
            resource.addResourceAssignment(resourceAssignment);
        }
        this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
    }

    private void populateResourceAssignmentWorkgroupFields(Record record, ResourceAssignmentWorkgroupFields resourceAssignmentWorkgroupFields) throws MPXJException {
        resourceAssignmentWorkgroupFields.setMessageUniqueID(record.getString(0));
        resourceAssignmentWorkgroupFields.setConfirmed(NumberHelper.getInt(record.getInteger(1)) == 1);
        resourceAssignmentWorkgroupFields.setResponsePending(NumberHelper.getInt(record.getInteger(1)) == 1);
        resourceAssignmentWorkgroupFields.setUpdateStart(record.getDateTime(3));
        resourceAssignmentWorkgroupFields.setUpdateFinish(record.getDateTime(4));
        resourceAssignmentWorkgroupFields.setScheduleID(record.getString(5));
    }

    static void populateFileCreationRecord(Record record, ProjectProperties projectProperties) {
        projectProperties.setMpxProgramName(record.getString(0));
        projectProperties.setMpxFileVersion(FileVersion.getInstance(record.getString(1)));
        projectProperties.setMpxCodePage(record.getCodePage(2));
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale[] getSupportedLocales() {
        return LocaleUtility.getSupportedLocales();
    }

    public void setIgnoreTextModels(boolean bl) {
        this.m_ignoreTextModels = bl;
    }

    public boolean getIgnoreTextModels() {
        return this.m_ignoreTextModels;
    }

    protected static class DeferredRelationship {
        private Task m_task;
        private TaskField m_field;
        private String m_data;

        protected DeferredRelationship() {
        }

        public Task getTask() {
            return this.m_task;
        }

        public void setTask(Task task) {
            this.m_task = task;
        }

        public TaskField getField() {
            return this.m_field;
        }

        public void setField(TaskField taskField) {
            this.m_field = taskField;
        }

        public String getData() {
            return this.m_data;
        }

        public void setData(String string) {
            this.m_data = string;
        }
    }
}

