/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.util.Arrays;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.lucene.HindiNormalizer;
import org.carrot2.text.linguistic.lucene.HindiStemmer;
import org.carrot2.text.linguistic.lucene.IndicNormalizer;
import org.carrot2.text.util.MutableCharArray;

public class HindiStemmerAdapter
implements IStemmer {
    final IndicNormalizer indicNormalizer = new IndicNormalizer();
    final HindiNormalizer hindiNormalizer = new HindiNormalizer();
    final HindiStemmer hindiStemmer = new HindiStemmer();
    private char[] buffer = new char[0];

    @Override
    public CharSequence stem(CharSequence word) {
        if (word.length() > this.buffer.length) {
            this.buffer = new char[word.length()];
        }
        for (int i = 0; i < word.length(); ++i) {
            this.buffer[i] = word.charAt(i);
        }
        int len = word.length();
        len = this.indicNormalizer.normalize(this.buffer, len);
        len = this.hindiNormalizer.normalize(this.buffer, len);
        if (!this.equals(word, this.buffer, len = this.hindiStemmer.stem(this.buffer, len))) {
            return new MutableCharArray(Arrays.copyOf(this.buffer, len));
        }
        return word;
    }

    private boolean equals(CharSequence word, char[] text, int len) {
        if (word.length() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (word.charAt(i) == text[i]) continue;
            return false;
        }
        return true;
    }
}

