/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.xslf.XSLFEventBasedPowerPointExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SXSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String HANDOUT_MASTER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/handoutMaster";
    private static final String[] MAIN_STORY_PART_RELATIONS = new String[]{XSLFRelation.MAIN.getContentType(), XSLFRelation.PRESENTATION_MACRO.getContentType(), XSLFRelation.PRESENTATIONML.getContentType(), XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), XSLFRelation.MACRO.getContentType(), XSLFRelation.MACRO_TEMPLATE.getContentType(), XSLFRelation.THEME_MANAGER.getContentType()};
    private final OPCPackage opcPackage;
    private final ParseContext context;
    private final Metadata metadata;
    private PackagePart mainDocument = null;
    private final CommentAuthors commentAuthors = new CommentAuthors();

    public SXSLFPowerPointExtractorDecorator(Metadata metadata, ParseContext context, XSLFEventBasedPowerPointExtractor extractor) {
        super(context, extractor);
        this.metadata = metadata;
        this.context = context;
        this.opcPackage = extractor.getPackage();
        for (String contentType : MAIN_STORY_PART_RELATIONS) {
            ArrayList pps = this.opcPackage.getPartsByContentType(contentType);
            if (pps.size() <= 0) continue;
            this.mainDocument = (PackagePart)pps.get(0);
            break;
        }
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        this.loadCommentAuthors();
        PackageRelationshipCollection slidesPRC = null;
        try {
            slidesPRC = this.mainDocument.getRelationshipsByType(XSLFRelation.SLIDE.getRelation());
        }
        catch (InvalidFormatException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (slidesPRC != null && slidesPRC.size() > 0) {
            for (int i = 0; i < slidesPRC.size(); ++i) {
                try {
                    this.handleSlidePart(this.mainDocument.getRelatedPart(slidesPRC.getRelationship(i)), xhtml);
                    continue;
                }
                catch (ZipException | InvalidFormatException e) {
                    this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        this.handleGeneralTextContainingPart(XSLFRelation.SLIDE_MASTER.getRelation(), "slide-master", this.mainDocument, this.metadata, new PlaceHolderSkipper(new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>())));
        this.handleGeneralTextContainingPart(HANDOUT_MASTER, "slide-handout-master", this.mainDocument, this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
    }

    private void loadCommentAuthors() {
        PackageRelationshipCollection prc = null;
        try {
            prc = this.mainDocument.getRelationshipsByType(XSLFRelation.COMMENT_AUTHORS.getRelation());
        }
        catch (InvalidFormatException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (prc == null || prc.size() == 0) {
            return;
        }
        for (int i = 0; i < prc.size(); ++i) {
            PackagePart commentAuthorsPart = null;
            try {
                commentAuthorsPart = this.mainDocument.getRelatedPart(prc.getRelationship(i));
            }
            catch (InvalidFormatException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (commentAuthorsPart == null) continue;
            try (InputStream stream = commentAuthorsPart.getInputStream();){
                this.context.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new XSLFCommentAuthorHandler()));
                continue;
            }
            catch (IOException | TikaException | SAXException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void handleSlidePart(PackagePart slidePart, XHTMLContentHandler xhtml) throws IOException, SAXException {
        Map<String, String> linkedRelationships = this.loadLinkedRelationships(slidePart, false, this.metadata);
        xhtml.startElement("div", "class", "slide-content");
        try (InputStream stream = slidePart.getInputStream();){
            this.context.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler((ContentHandler)new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships))));
        }
        catch (TikaException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        xhtml.endElement("div");
        this.handleGeneralTextContainingPart(XSLFRelation.SLIDE_LAYOUT.getRelation(), "slide-master-content", slidePart, this.metadata, new PlaceHolderSkipper(new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships)));
        this.handleGeneralTextContainingPart(XSLFRelation.NOTES.getRelation(), "slide-notes", slidePart, this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
        this.handleGeneralTextContainingPart(XSLFRelation.NOTES_MASTER.getRelation(), "slide-notes-master", slidePart, this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
        this.handleGeneralTextContainingPart(XSLFRelation.COMMENTS.getRelation(), null, slidePart, this.metadata, new XSLFCommentsHandler(xhtml));
        this.handleGeneralTextContainingPart("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", "diagram-data", slidePart, this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
        this.handleGeneralTextContainingPart(XSLFRelation.CHART.getRelation(), "chart", slidePart, this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        PackageRelationshipCollection slidePRC = null;
        try {
            slidePRC = this.mainDocument.getRelationshipsByType(XSLFRelation.SLIDE.getRelation());
        }
        catch (InvalidFormatException e) {
            this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (slidePRC != null) {
            for (int i = 0; i < slidePRC.size(); ++i) {
                PackagePart slidePart = null;
                try {
                    slidePart = this.mainDocument.getRelatedPart(slidePRC.getRelationship(i));
                }
                catch (InvalidFormatException e) {
                    this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                }
                this.addSlideParts(slidePart, parts);
            }
        }
        parts.add(this.mainDocument);
        for (String rel : new String[]{XSLFRelation.SLIDE_MASTER.getRelation(), HANDOUT_MASTER}) {
            PackageRelationshipCollection prc = null;
            try {
                prc = this.mainDocument.getRelationshipsByType(rel);
            }
            catch (InvalidFormatException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (prc == null) continue;
            for (int i = 0; i < prc.size(); ++i) {
                PackagePart pp = null;
                try {
                    pp = this.mainDocument.getRelatedPart(prc.getRelationship(i));
                }
                catch (InvalidFormatException e) {
                    this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                }
                if (pp == null) continue;
                parts.add(pp);
            }
        }
        return parts;
    }

    private void addSlideParts(PackagePart slidePart, List<PackagePart> parts) {
        for (String relation : new String[]{XSLFRelation.VML_DRAWING.getRelation(), XSLFRelation.SLIDE_LAYOUT.getRelation(), XSLFRelation.NOTES_MASTER.getRelation(), XSLFRelation.NOTES.getRelation()}) {
            PackageRelationshipCollection prc = null;
            try {
                prc = slidePart.getRelationshipsByType(relation);
            }
            catch (InvalidFormatException e) {
                this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (prc == null) continue;
            for (PackageRelationship packageRelationship : prc) {
                if (packageRelationship.getTargetMode() != TargetMode.INTERNAL) continue;
                PackagePartName relName = null;
                try {
                    relName = PackagingURIHelper.createPartName((URI)packageRelationship.getTargetURI());
                }
                catch (InvalidFormatException e) {
                    this.metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, ExceptionUtils.getStackTrace((Throwable)e));
                }
                if (relName == null) continue;
                parts.add(packageRelationship.getPackage().getPart(relName));
            }
        }
        parts.add(slidePart);
    }

    private class CommentAuthors {
        Map<String, String> nameMap = new HashMap<String, String>();
        Map<String, String> initialMap = new HashMap<String, String>();

        private CommentAuthors() {
        }

        void add(String id, String name, String initials) {
            if (id == null) {
                return;
            }
            if (name != null) {
                this.nameMap.put(id, name);
            }
            if (initials != null) {
                this.initialMap.put(id, initials);
            }
        }

        String getName(String id) {
            if (id == null) {
                return null;
            }
            return this.nameMap.get(id);
        }

        String getInitials(String id) {
            if (id == null) {
                return null;
            }
            return this.initialMap.get(id);
        }
    }

    private static class PlaceHolderSkipper
    extends DefaultHandler {
        private final ContentHandler wrappedHandler;
        boolean inPH = false;

        PlaceHolderSkipper(ContentHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("ph".equals(localName)) {
                this.inPH = true;
            }
            if (!this.inPH) {
                this.wrappedHandler.startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.endElement(uri, localName, qName);
            }
            if ("sp".equals(localName)) {
                this.inPH = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.characters(ch, start, length);
            }
        }
    }

    private class XSLFCommentAuthorHandler
    extends DefaultHandler {
        String id = null;
        String name = null;
        String initials = null;

        private XSLFCommentAuthorHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("cmAuthor".equals(localName)) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    if ("id".equals(atts.getLocalName(i))) {
                        this.id = atts.getValue(i);
                        continue;
                    }
                    if ("name".equals(atts.getLocalName(i))) {
                        this.name = atts.getValue(i);
                        continue;
                    }
                    if (!"initials".equals(atts.getLocalName(i))) continue;
                    this.initials = atts.getValue(i);
                }
                SXSLFPowerPointExtractorDecorator.this.commentAuthors.add(this.id, this.name, this.initials);
                this.id = null;
                this.name = null;
                this.initials = null;
            }
        }
    }

    private class XSLFCommentsHandler
    extends DefaultHandler {
        private String commentAuthorId = null;
        private StringBuilder commentBuffer = new StringBuilder();
        private XHTMLContentHandler xhtml;

        XSLFCommentsHandler(XHTMLContentHandler xhtml) {
            this.xhtml = xhtml;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("cm".equals(localName)) {
                this.commentAuthorId = atts.getValue("", "authorId");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.commentBuffer.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("cm".equals(localName)) {
                this.xhtml.startElement("p", "class", "slide-comment");
                String authorString = SXSLFPowerPointExtractorDecorator.this.commentAuthors.getName(this.commentAuthorId);
                String authorInitials = SXSLFPowerPointExtractorDecorator.this.commentAuthors.getInitials(this.commentAuthorId);
                if (authorString != null || authorInitials != null) {
                    this.xhtml.startElement("b");
                    boolean authorExists = false;
                    if (authorString != null) {
                        this.xhtml.characters(authorString.toString());
                        authorExists = true;
                    }
                    if (authorExists && authorInitials != null) {
                        this.xhtml.characters(" (");
                    }
                    if (authorInitials != null) {
                        this.xhtml.characters(authorInitials);
                    }
                    if (authorExists && authorInitials != null) {
                        this.xhtml.characters(")");
                    }
                    this.xhtml.endElement("b");
                }
                this.xhtml.characters(this.commentBuffer.toString());
                this.xhtml.endElement("p");
                this.commentBuffer.setLength(0);
                this.commentAuthorId = null;
            }
        }
    }
}

