/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters.solr;

import com.codahale.metrics.MetricFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.metrics.SolrCoreReporter;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.reporters.solr.SolrReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrShardReporter
extends SolrCoreReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<String> DEFAULT_FILTERS = new ArrayList(){
        {
            this.add("TLOG.*");
            this.add("CORE\\.fs.*");
            this.add("REPLICATION.*");
            this.add("INDEX\\.flush.*");
            this.add("INDEX\\.merge\\.major.*");
            this.add("UPDATE\\./update/.*requests");
            this.add("QUERY\\./select.*requests");
        }
    };
    private String handler = "/admin/metrics/collector";
    private SolrReporter reporter;

    public SolrShardReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    protected void doInit() {
        if (this.filters.isEmpty()) {
            this.filters = DEFAULT_FILTERS;
        }
    }

    @Override
    protected MetricFilter newMetricFilter() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + ".newMetricFilter() is not supported");
    }

    @Override
    protected void validate() throws IllegalStateException {
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }

    @Override
    public void init(PluginInfo pluginInfo, SolrCore core) {
        super.init(pluginInfo, core);
        if (this.reporter != null) {
            this.reporter.close();
        }
        if (!this.enabled) {
            log.info("Reporter disabled for registry " + this.registryName);
            return;
        }
        if (core.getCoreDescriptor().getCloudDescriptor() == null) {
            log.warn("Not initializing shard reporter for non-cloud core " + core.getName());
            return;
        }
        if (this.period < 1) {
            log.warn("period=" + this.period + ", not starting shard reporter ");
            return;
        }
        String id = core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName();
        String groupId = core.getCoreMetricManager().getLeaderRegistryName();
        if (groupId == null) {
            log.warn("No leaderRegistryName for core " + core + ", not starting the reporter...");
            return;
        }
        SolrReporter.Report spec = new SolrReporter.Report(groupId, null, this.registryName, this.filters);
        this.reporter = SolrReporter.Builder.forReports(this.metricManager, Collections.singletonList(spec)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withHandler(this.handler).withReporterId(id).setCompact(true).cloudClient(false).skipAggregateValues(true).skipHistograms(true).build(core.getCoreContainer().getUpdateShardHandler().getHttpClient(), new LeaderUrlSupplier(core));
        this.reporter.start(this.period, TimeUnit.SECONDS);
    }

    private static class LeaderUrlSupplier
    implements Supplier<String> {
        private SolrCore core;

        LeaderUrlSupplier(SolrCore core) {
            this.core = core;
        }

        @Override
        public String get() {
            CloudDescriptor cd = this.core.getCoreDescriptor().getCloudDescriptor();
            if (cd == null) {
                return null;
            }
            ClusterState state = this.core.getCoreContainer().getZkController().getClusterState();
            DocCollection collection = state.getCollection(this.core.getCoreDescriptor().getCollectionName());
            Replica replica = collection.getLeader(this.core.getCoreDescriptor().getCloudDescriptor().getShardId());
            if (replica == null) {
                log.warn("No leader for " + collection.getName() + "/" + this.core.getCoreDescriptor().getCloudDescriptor().getShardId());
                return null;
            }
            String baseUrl = replica.getStr("base_url");
            if (baseUrl == null) {
                log.warn("No base_url for replica " + replica);
            }
            return baseUrl;
        }
    }
}

