/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientInfoGenerator;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int _bufferSize;
    private boolean _berEncodeRecipientSet;

    public CMSAuthenticatedDataStreamGenerator() {
    }

    public CMSAuthenticatedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void setBEREncodeRecipients(boolean bl) {
        this._berEncodeRecipientSet = bl;
    }

    private OutputStream open(OutputStream outputStream, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider provider2 = keyGenerator.getProvider();
        SecretKey secretKey = keyGenerator.generateKey();
        AlgorithmParameterSpec algorithmParameterSpec = this.generateParameterSpec(string, secretKey, provider2);
        Iterator iterator = this.recipientInfoGenerators.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            RecipientInfoGenerator recipientInfoGenerator = (RecipientInfoGenerator)iterator.next();
            try {
                aSN1EncodableVector.add((DEREncodable)recipientInfoGenerator.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        return this.open(outputStream, string, secretKey, algorithmParameterSpec, aSN1EncodableVector, provider2);
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec, ASN1EncodableVector aSN1EncodableVector, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.open(outputStream, string, secretKey, algorithmParameterSpec, aSN1EncodableVector, CMSUtils.getProvider(string2));
    }

    protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec, ASN1EncodableVector aSN1EncodableVector, Provider provider) throws NoSuchAlgorithmException, CMSException {
        try {
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.authenticatedData);
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            bERSequenceGenerator2.addObject((DEREncodable)new DERInteger(AuthenticatedData.calculateVersion(null)));
            if (this._berEncodeRecipientSet) {
                bERSequenceGenerator2.getRawOutputStream().write(new BERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            } else {
                bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            }
            Mac mac = CMSEnvelopedHelper.INSTANCE.getMac(string, provider);
            mac.init(secretKey, algorithmParameterSpec);
            AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(string, algorithmParameterSpec, provider);
            bERSequenceGenerator2.getRawOutputStream().write(algorithmIdentifier.getEncoded());
            BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
            bERSequenceGenerator3.addObject((DEREncodable)CMSObjectIdentifiers.data);
            OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, false, this._bufferSize);
            CMSAuthenticatedGenerator.MacOutputStream macOutputStream = new CMSAuthenticatedGenerator.MacOutputStream(outputStream2, mac);
            return new CmsAuthenticatedDataOutputStream(macOutputStream, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameter invalid.", invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("algorithm parameter spec invalid.", invalidParameterSpecException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    public OutputStream open(OutputStream outputStream, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string, CMSUtils.getProvider(string2));
    }

    public OutputStream open(OutputStream outputStream, String string, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.open(outputStream, string, keyGenerator, provider);
    }

    public OutputStream open(OutputStream outputStream, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        return this.open(outputStream, string, n, CMSUtils.getProvider(string2));
    }

    public OutputStream open(OutputStream outputStream, String string, int n, Provider provider) throws NoSuchAlgorithmException, CMSException, IOException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(n, this.rand);
        return this.open(outputStream, string, keyGenerator, provider);
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private CMSAuthenticatedGenerator.MacOutputStream macStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;

        public CmsAuthenticatedDataOutputStream(CMSAuthenticatedGenerator.MacOutputStream macOutputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.macStream = macOutputStream;
            this.cGen = bERSequenceGenerator;
            this.envGen = bERSequenceGenerator2;
            this.eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this.macStream.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.macStream.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.macStream.write(byArray);
        }

        public void close() throws IOException {
            this.macStream.close();
            this.eiGen.close();
            this.envGen.addObject((DEREncodable)new DEROctetString(this.macStream.getMac()));
            this.envGen.close();
            this.cGen.close();
        }
    }
}

