/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import virtuoso.jdbc4.VirtuosoExplicitString;

public class VirtuosoXid
implements Xid {
    private int formatId;
    private byte[] globalId;
    private byte[] branchId;
    private static final byte[] encodeTable;
    private static final byte[] decodeTable;

    public VirtuosoXid(Xid xid) throws XAException {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public VirtuosoXid(int n, byte[] byArray, byte[] byArray2) throws XAException {
        this.formatId = n;
        this.globalId = this.copyId(byArray);
        this.branchId = this.copyId(byArray2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            if (this.formatId != xid.getFormatId()) {
                return false;
            }
            if (!this.equalIds(this.globalId, xid.getGlobalTransactionId())) {
                return false;
            }
            return this.equalIds(this.branchId, xid.getBranchQualifier());
        }
        return false;
    }

    public int hashCode() {
        return this.formatId + this.hashId(this.globalId) + this.hashId(this.branchId);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalId == null ? null : (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchId == null ? null : (byte[])this.branchId.clone();
    }

    VirtuosoExplicitString encode() {
        byte[] byArray = new byte[280];
        VirtuosoXid.encode(this.formatId, byArray, 0);
        VirtuosoXid.encode(this.globalId.length, byArray, 8);
        VirtuosoXid.encode(this.branchId.length, byArray, 16);
        VirtuosoXid.encode(this.globalId, byArray, 24);
        VirtuosoXid.encode(this.branchId, byArray, 24 + this.globalId.length * 2);
        for (int i = 24 + (this.globalId.length + this.branchId.length) * 2; i < 280; ++i) {
            byArray[i] = 48;
        }
        return new VirtuosoExplicitString(byArray, 182);
    }

    static VirtuosoXid decode(String string) throws XAException {
        int n = VirtuosoXid.decode(string, 0);
        int n2 = VirtuosoXid.decode(string, 8);
        if (n2 > 64) {
            throw new XAException(-3);
        }
        int n3 = VirtuosoXid.decode(string, 16);
        if (n3 > 64) {
            throw new XAException(-3);
        }
        byte[] byArray = VirtuosoXid.decode(string, 24, n2);
        byte[] byArray2 = VirtuosoXid.decode(string, 24 + n2 * 2, n3);
        return new VirtuosoXid(n, byArray, byArray2);
    }

    private byte[] copyId(byte[] byArray) throws XAException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length > 64) {
            throw new XAException(-4);
        }
        return (byte[])byArray.clone();
    }

    private boolean equalIds(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2 || byArray == null && byArray2.length == 0 || byArray2 == null && byArray.length == 0) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int hashId(byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                n = n * 17 + byArray[i];
            }
        }
        return n;
    }

    private static void encode(int n, byte[] byArray, int n2) {
        byte[] byArray2 = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        VirtuosoXid.encode(byArray2, byArray, n2);
    }

    private static void encode(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            byArray2[n++] = encodeTable[by >> 4 & 0xF];
            byArray2[n++] = encodeTable[by & 0xF];
        }
    }

    private static int decode(String string, int n) {
        byte[] byArray = VirtuosoXid.decode(string, n, 4);
        int n2 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n2;
    }

    private static byte[] decode(String string, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(decodeTable[string.charAt(n)] << 4 | decodeTable[string.charAt(n + 1)]);
            n += 2;
        }
        return byArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("formatId:" + this.formatId);
        stringBuffer.append("globalId length:" + this.globalId.length);
        stringBuffer.append(":");
        for (n = 0; n < this.globalId.length; ++n) {
            stringBuffer.append(" " + this.globalId[n]);
        }
        stringBuffer.append(" branchId length:" + this.branchId.length);
        stringBuffer.append(":");
        for (n = 0; n < this.branchId.length; ++n) {
            stringBuffer.append(" " + this.branchId[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append("encoded:" + this.encode().toString());
        return stringBuffer.toString();
    }

    private void print() {
        System.out.println("formatId: " + this.formatId);
        this.print("globalId", this.globalId);
        this.print("branchId", this.branchId);
    }

    private void print(String string, byte[] byArray) {
        System.out.println(string + " length: " + byArray.length);
        System.out.print(string + ":");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(" " + byArray[i]);
        }
        System.out.println();
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        for (int i = 0; i < 64; ++i) {
            byArray[i] = (byte)(256.0 * Math.random());
            byArray2[i] = (byte)(256.0 * Math.random());
        }
        VirtuosoXid virtuosoXid = new VirtuosoXid(0, byArray, byArray2);
        System.out.println("encode str=" + virtuosoXid.encode());
        VirtuosoXid virtuosoXid2 = VirtuosoXid.decode(virtuosoXid.encode().toString());
        if (virtuosoXid.equals(virtuosoXid2)) {
            System.out.println("passed");
        } else {
            System.out.println("failed");
        }
        virtuosoXid.print();
        virtuosoXid2.print();
    }

    static {
        int n;
        encodeTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        decodeTable = new byte[256];
        for (n = 0; n < 256; ++n) {
            VirtuosoXid.decodeTable[n] = -1;
        }
        for (n = 0; n < encodeTable.length; ++n) {
            VirtuosoXid.decodeTable[VirtuosoXid.encodeTable[n]] = (byte)n;
        }
    }
}

