"""Generated client library for datapol version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.datapol.v1alpha1 import datapol_v1alpha1_messages as messages


class DatapolV1alpha1(base_api.BaseApiClient):
  """Generated client library for service datapol version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://datapol.googleapis.com/'

  _PACKAGE = u'datapol'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/xapi.zoo']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'DatapolV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new datapol handle."""
    url = url or self.BASE_URL
    super(DatapolV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.data_taxonomyStores_annotationTags = self.DataTaxonomyStoresAnnotationTagsService(self)
    self.data_taxonomyStores_dataTaxonomies = self.DataTaxonomyStoresDataTaxonomiesService(self)
    self.data_taxonomyStores = self.DataTaxonomyStoresService(self)
    self.data = self.DataService(self)
    self.dataAssets = self.DataAssetsService(self)
    self.projects = self.ProjectsService(self)
    self.taxonomyStores_dataTaxonomies_annotations = self.TaxonomyStoresDataTaxonomiesAnnotationsService(self)
    self.taxonomyStores_dataTaxonomies = self.TaxonomyStoresDataTaxonomiesService(self)
    self.taxonomyStores = self.TaxonomyStoresService(self)

  class DataTaxonomyStoresAnnotationTagsService(base_api.BaseApiService):
    """Service class for the data_taxonomyStores_annotationTags resource."""

    _NAME = u'data_taxonomyStores_annotationTags'

    def __init__(self, client):
      super(DatapolV1alpha1.DataTaxonomyStoresAnnotationTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      """Lists all visible annotation tags from a taxonomy store that are applied on.
a cloud data set.

      Args:
        request: (DatapolDataTaxonomyStoresAnnotationTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/taxonomyStores/{taxonomyStoresId}/annotationTags',
        http_method=u'GET',
        method_id=u'datapol.data.taxonomyStores.annotationTags.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dataSubsetName', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/annotationTags',
        request_field='',
        request_type_name=u'DatapolDataTaxonomyStoresAnnotationTagsListRequest',
        response_type_name=u'ListAnnotationTagsResponse',
        supports_download=False,
    )

  class DataTaxonomyStoresDataTaxonomiesService(base_api.BaseApiService):
    """Service class for the data_taxonomyStores_dataTaxonomies resource."""

    _NAME = u'data_taxonomyStores_dataTaxonomies'

    def __init__(self, client):
      super(DatapolV1alpha1.DataTaxonomyStoresDataTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def ApplyAnnotationTag(self, request, global_params=None):
      """Applies an annotation tag on a cloud data set.

      Args:
        request: (DatapolDataTaxonomyStoresDataTaxonomiesApplyAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationTag) The response message.
      """
      config = self.GetMethodConfig('ApplyAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}:applyAnnotationTag',
        http_method=u'POST',
        method_id=u'datapol.data.taxonomyStores.dataTaxonomies.applyAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}:applyAnnotationTag',
        request_field=u'applyAnnotationTagRequest',
        request_type_name=u'DatapolDataTaxonomyStoresDataTaxonomiesApplyAnnotationTagRequest',
        response_type_name=u'AnnotationTag',
        supports_download=False,
    )

    def DeleteAnnotationTag(self, request, global_params=None):
      """Deletes an annotation tag from a cloud data set.

      Args:
        request: (DatapolDataTaxonomyStoresDataTaxonomiesDeleteAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DeleteAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/data/{dataId}/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotationTag',
        http_method=u'DELETE',
        method_id=u'datapol.data.taxonomyStores.dataTaxonomies.deleteAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'dataSubsetName'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolDataTaxonomyStoresDataTaxonomiesDeleteAnnotationTagRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

  class DataTaxonomyStoresService(base_api.BaseApiService):
    """Service class for the data_taxonomyStores resource."""

    _NAME = u'data_taxonomyStores'

    def __init__(self, client):
      super(DatapolV1alpha1.DataTaxonomyStoresService, self).__init__(client)
      self._upload_configs = {
          }

  class DataService(base_api.BaseApiService):
    """Service class for the data resource."""

    _NAME = u'data'

    def __init__(self, client):
      super(DatapolV1alpha1.DataService, self).__init__(client)
      self._upload_configs = {
          }

  class DataAssetsService(base_api.BaseApiService):
    """Service class for the dataAssets resource."""

    _NAME = u'dataAssets'

    def __init__(self, client):
      super(DatapolV1alpha1.DataAssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def ListResourceNames(self, request, global_params=None):
      """Lists all cloud data assets with given predicates.

      Args:
        request: (DatapolDataAssetsListResourceNamesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('ListResourceNames')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListResourceNames.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'datapol.dataAssets.listResourceNames',
        ordered_params=[],
        path_params=[],
        query_params=[u'annotatableOnly', u'annotations', u'filter', u'includeAnnotatedByGroup', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/dataAssets:ListResourceNames',
        request_field='',
        request_type_name=u'DatapolDataAssetsListResourceNamesRequest',
        response_type_name=u'ListAssetsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DatapolV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetDefaultTaxonomyStore(self, request, global_params=None):
      """Search for the taxonomy store for the given project.

      Args:
        request: (DatapolProjectsGetDefaultTaxonomyStoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaxonomyStore) The response message.
      """
      config = self.GetMethodConfig('GetDefaultTaxonomyStore')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDefaultTaxonomyStore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/defaultTaxonomyStore',
        http_method=u'GET',
        method_id=u'datapol.projects.getDefaultTaxonomyStore',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolProjectsGetDefaultTaxonomyStoreRequest',
        response_type_name=u'TaxonomyStore',
        supports_download=False,
    )

  class TaxonomyStoresDataTaxonomiesAnnotationsService(base_api.BaseApiService):
    """Service class for the taxonomyStores_dataTaxonomies_annotations resource."""

    _NAME = u'taxonomyStores_dataTaxonomies_annotations'

    def __init__(self, client):
      super(DatapolV1alpha1.TaxonomyStoresDataTaxonomiesAnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates an annotation in a taxonomy.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesAnnotationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotations',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.annotations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/annotations',
        request_field=u'annotation',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesAnnotationsCreateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes an annotation. Also deletes all member annotations if the given.
annotation is a group annotation.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'DELETE',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.annotations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesAnnotationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Gets definition of an annotation.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'GET',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.annotations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all annotations in a taxonomy.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesAnnotationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotations',
        http_method=u'GET',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.annotations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/annotations',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesAnnotationsListRequest',
        response_type_name=u'ListAnnotationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      """Updates description of an annotation.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesAnnotationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}/annotations/{annotationsId}',
        http_method=u'PATCH',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.annotations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'updateAnnotationRequest',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesAnnotationsPatchRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class TaxonomyStoresDataTaxonomiesService(base_api.BaseApiService):
    """Service class for the taxonomyStores_dataTaxonomies resource."""

    _NAME = u'taxonomyStores_dataTaxonomies'

    def __init__(self, client):
      super(DatapolV1alpha1.TaxonomyStoresDataTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Creates a new data taxonomy in a given taxonomy store.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataTaxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/dataTaxonomies',
        request_field=u'dataTaxonomy',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesCreateRequest',
        response_type_name=u'DataTaxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Deletes a taxonomy from a taxonomy store. This operation will also delete.
all annotations in this taxonomy.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}',
        http_method=u'DELETE',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Returns the taxonomy referred by name. Size of a taxonomy is at most 100KB.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataTaxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}',
        http_method=u'GET',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesGetRequest',
        response_type_name=u'DataTaxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """GetIamPolicy method for the taxonomyStores_dataTaxonomies service.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists all taxonomies in a taxonomy store.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies',
        http_method=u'GET',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/dataTaxonomies',
        request_field='',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesListRequest',
        response_type_name=u'ListDataTaxonomiesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """SetIamPolicy method for the taxonomyStores_dataTaxonomies service.

      Args:
        request: (DatapolTaxonomyStoresDataTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}/dataTaxonomies/{dataTaxonomiesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.dataTaxonomies.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatapolTaxonomyStoresDataTaxonomiesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class TaxonomyStoresService(base_api.BaseApiService):
    """Service class for the taxonomyStores resource."""

    _NAME = u'taxonomyStores'

    def __init__(self, client):
      super(DatapolV1alpha1.TaxonomyStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      """GetIamPolicy method for the taxonomyStores service.

      Args:
        request: (DatapolTaxonomyStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'DatapolTaxonomyStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """SetIamPolicy method for the taxonomyStores service.

      Args:
        request: (DatapolTaxonomyStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/taxonomyStores/{taxonomyStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'datapol.taxonomyStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DatapolTaxonomyStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )
