<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title> Mise en correspondance des URLs avec le systme de fichiers - Serveur HTTP Apache Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1> Mise en correspondance des URLs avec le systme de fichiers</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/urlmapping.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/urlmapping.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/urlmapping.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/urlmapping.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/urlmapping.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Ce document explique comment le serveur HTTP Apache utilise l'URL contenue dans une
    requte pour dterminer le noeud du systme de fichier  partir duquel le
    fichier devra tre servi.</p>
  </div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#related">Modules et directives concerns</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#documentroot">Racine des documents (DocumentRoot)</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#outside">Fichiers situs en dehors de
l'arborescence DocumentRoot</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#user">Rpertoires des utilisateurs</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#redirect">Redirection d'URL</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#proxy">Mandataire inverse (Reverse Proxy)</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#rewrite">Moteur de rcriture</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#notfound">Fichier non trouv (File Not Found)</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#other">Autres modules de mise en correspondance des
URLs</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Modules et directives concerns</a></h2>

<table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_actions.html">mod_actions</a></code></li><li><code class="module"><a href="./mod/mod_alias.html">mod_alias</a></code></li><li><code class="module"><a href="./mod/mod_autoindex.html">mod_autoindex</a></code></li><li><code class="module"><a href="./mod/mod_dir.html">mod_dir</a></code></li><li><code class="module"><a href="./mod/mod_imagemap.html">mod_imagemap</a></code></li><li><code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code></li><li><code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li><li><code class="module"><a href="./mod/mod_speling.html">mod_speling</a></code></li><li><code class="module"><a href="./mod/mod_userdir.html">mod_userdir</a></code></li><li><code class="module"><a href="./mod/mod_vhost_alias.html">mod_vhost_alias</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_alias.html#alias">Alias</a></code></li><li><code class="directive"><a href="./mod/mod_alias.html#aliasmatch">AliasMatch</a></code></li><li><code class="directive"><a href="./mod/mod_speling.html#checkspelling">CheckSpelling</a></code></li><li><code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code></li><li><code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code></li><li><code class="directive"><a href="./mod/core.html#errordocument">ErrorDocument</a></code></li><li><code class="directive"><a href="./mod/core.html#options">Options</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxypass">ProxyPass</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxypassreverse">ProxyPassReverse</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxypassreversecookiedomain">ProxyPassReverseCookieDomain</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxypassreversecookiepath">ProxyPassReverseCookiePath</a></code></li><li><code class="directive"><a href="./mod/mod_alias.html#redirect">Redirect</a></code></li><li><code class="directive"><a href="./mod/mod_alias.html#redirectmatch">RedirectMatch</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li><li><code class="directive"><a href="./mod/mod_alias.html#scriptalias">ScriptAlias</a></code></li><li><code class="directive"><a href="./mod/mod_alias.html#scriptaliasmatch">ScriptAliasMatch</a></code></li><li><code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code></li></ul></td></tr></table>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="documentroot" id="documentroot">Racine des documents (DocumentRoot)</a></h2>

    <p>La mthode par dfaut de httpd pour dterminer quel fichier servir pour
    une requte donne, consiste  extraire le chemin du fichier de la requte
    (la partie de l'URL qui suit le nom d'hte et le port), puis de l'ajouter
     la fin de la valeur de la directive
    <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code> dfinie dans vos fichiers
    de configuration.
    Ainsi, les fichiers et rpertoires
    situs en dessous de <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>
    constituent l'arborescence de base des documents qui seront visibles
    depuis le web.</p>

    <p>Par exemple, si la directive
    <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code> contient
    <code>/var/www/html</code>, une requte pour
    <code>http://www.example.com/fish/guppies.html</code> retournera le
    fichier <code>/var/www/html/fish/guppies.html</code> au client.</p>

    <p>Si la requte concerne un rpertoire (autrement dit un chemin se
    terminant par un slash <code>/</code>), le nom du fichier qui sera
    recherch et servi depuis ce rpertoire est dfini via la directive
    <code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>. Par exemple,
    supposons que <code>DocumentRoot</code> ait t dfinie comme
    prcdemment, et que vous ayez dfini <code>DirectoryIndex</code>
    comme suit :</p>

    <div class="example"><p><code>DirectoryIndex index.html index.php</code></p></div>

    <p>Si httpd reoit alors une requte pour
    <code>http://www.example.com/fish/</code>, il tentera de servir le
    fichier <code>/var/www/html/fish/index.html</code>. Si ce fichier
    n'existe pas, il tentera de servir le fichier
    <code>/var/www/html/fish/index.php</code>.</p>

    <p>Si aucun de ces fichiers existe, httpd tentera de gnrer et
    d'afficher un index du rpertoire,  condition que
    <code class="module"><a href="./mod/mod_autoindex.html">mod_autoindex</a></code> ait t charg et configur pour le
    permettre.</p>

    <p>httpd supporte aussi les <a href="vhosts/">Htes virtuels</a>,
    ce qui lui permet de traiter des requtes pour plusieurs htes.
    Dans ce cas, un <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>
    diffrent peut tre dfini pour chaque hte virtuel;
    les directives fournies par le module
    <code class="module"><a href="./mod/mod_vhost_alias.html">mod_vhost_alias</a></code> peuvent aussi tre utilises afin de
    dterminer dynamiquement le noeud appropri du systme de fichiers
     partir duquel servir un contenu en fonction de l'adresse IP
    ou du nom d'hte.</p>

    <p>La directive <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>  est
    dfinie dans le fichier de configuration de votre serveur principal
    (<code>httpd.conf</code>), mais peut aussi tre redfinie pour chaque
    <a href="vhosts/">Hte virtuel</a> supplmentaire que vous avez cr.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="outside" id="outside">Fichiers situs en dehors de
l'arborescence DocumentRoot</a></h2>

    <p>Il existe de nombreuses circonstances pour lesquelles il est ncessaire
    d'autoriser l'accs web  des portions du systme de fichiers qui ne se
    trouvent pas dans l'arborescence <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>.  httpd propose de nombreuses
    solutions pour raliser cela. Sur les systmes Unix, les liens
    symboliques permettent de rattacher d'autres portions du systme de
    fichiers au <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>. Pour des raisons de scurit,
    httpd ne suivra les liens symboliques que si les <code class="directive"><a href="./mod/core.html#options">Options</a></code> pour le rpertoire concern contiennent
    <code>FollowSymLinks</code> ou <code>SymLinksIfOwnerMatch</code>.</p>

    <p>Une autre mthode consiste  utiliser la directive <code class="directive"><a href="./mod/mod_alias.html#alias">Alias</a></code> pour rattacher toute portion
    du systme de fichiers  l'arborescence du site web. Par exemple, avec</p>

<pre class="prettyprint lang-config">Alias "/docs" "/var/web"</pre>


    <p>l'URL <code>http://www.example.com/docs/dir/file.html</code>
    correspondra au fichier <code>/var/web/dir/file.html</code>. La
    directive
    <code class="directive"><a href="./mod/mod_alias.html#scriptalias">ScriptAlias</a></code>
    fonctionne de la mme manire, except que tout contenu localis dans le
    chemin cible sera trait comme un script <a class="glossarylink" href="./glossary.html#cgi" title="voir glossaire">CGI</a>.</p>

    <p>Pour les situations qui ncessitent plus de flexibilit, vous disposez
    des directives <code class="directive"><a href="./mod/mod_alias.html#aliasmatch">AliasMatch</a></code>
    et <code class="directive"><a href="./mod/mod_alias.html#scriptaliasmatch">ScriptAliasMatch</a></code>
    qui permettent des substitutions et comparaisons puissantes bases
    sur les <a class="glossarylink" href="./glossary.html#regex" title="voir glossaire">expressions rationnelles</a>.
    Par exemple,</p>

<pre class="prettyprint lang-config">ScriptAliasMatch "^/~([a-zA-Z0-9]+)/cgi-bin/(.+)" "/home/$1/cgi-bin/$2"</pre>


    <p>fera correspondre une requte du style
    <code>http://example.com/~user/cgi-bin/script.cgi</code> au chemin
    <code>/home/user/cgi-bin/script.cgi</code>, et traitera le fichier rsultant
    comme un script CGI.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="user" id="user">Rpertoires des utilisateurs</a></h2>

    <p>Sur les systmes Unix, on peut traditionnellement faire rfrence
    au rpertoire personnel d'un <em>utilisateur</em> particulier  l'aide de
    l'expression <code>~user/</code>.
    Le module <code class="module"><a href="./mod/mod_userdir.html">mod_userdir</a></code>
    tend cette ide au web en autorisant l'accs aux fichiers situs dans les
    rpertoires home des utilisateurs  l'aide d'URLs
    comme dans ce qui suit :</p>

<div class="example"><p><code>http://www.example.com/~user/file.html</code></p></div>

    <p>Pour des raisons de scurit, il est dconseill de permettre un accs
    direct  un rpertoire home d'utilisateur depuis le web. A cet effet, la
    directive <code class="directive"><a href="./mod/mod_userdir.html#userdir">UserDir</a></code>
    spcifie un rpertoire o sont situs les fichiers accessibles depuis le web
    dans le rpertoire home de l'utilisateur.
    Avec la configuration par dfaut
    <code>Userdir public_html</code>, l'URL ci-dessus correspondra  un fichier
    dont le chemin sera du style
    <code>/home/user/public_html/file.html</code> o
    <code>/home/user/</code> est le rpertoire home de l'utilisateur tel qu'il
    est dfini dans <code>/etc/passwd</code>.</p>

    <p>La directive <code>Userdir</code> met  votre disposition de nombreuses
    formes diffrentes pour les systmes o <code>/etc/passwd</code> ne
    spcifie pas la localisation du rpertoire home.</p>

    <p>Certains jugent le symbole "~" (dont le code sur le web est souvent
    <code>%7e</code>) inappropri et prfrent utiliser une chane de
    caractres diffrente pour reprsenter les rpertoires utilisateurs.
    mod_userdir ne supporte pas cette fonctionnalit. Cependant, si les
    rpertoires home des utilisateurs sont structurs de manire rationnelle,
    il est possible d'utiliser la directive
    <code class="directive"><a href="./mod/mod_alias.html#aliasmatch">AliasMatch</a></code>
    pour obtenir l'effet dsir. Par exemple, pour faire correspondre
    <code>http://www.example.com/upages/user/file.html</code> 
    <code>/home/user/public_html/file.html</code>, utilisez la directive
    <code>AliasMatch</code> suivante :</p>

<pre class="prettyprint lang-config">AliasMatch "^/upages/([a-zA-Z0-9]+)(/(.*))?$"   "/home/$1/public_html/$3"</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="redirect" id="redirect">Redirection d'URL</a></h2>

    <p>Les directives de configuration dcrites dans les sections prcdentes
    demandent  httpd d'extraire un contenu depuis un emplacement spcifique
    du systme de fichiers
    et de la retourner au client. Il est cependant parfois
    souhaitable d'informer le
    client que le contenu demand est localis  une URL diffrente, et de
    demander au client d'laborer une nouvelle requte avec la nouvelle URL.
    Ce processus se nomme <em>redirection</em> et est implment par la
    directive <code class="directive"><a href="./mod/mod_alias.html#redirect">Redirect</a></code>.
    Par exemple, si le contenu du rpertoire <code>/foo/</code> sous
    <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code> est dplac vers le
    nouveau rpertoire <code>/bar/</code>, vous pouvez demander aux clients
    de le requrir  sa nouvelle localisation comme suit :</p>

<pre class="prettyprint lang-config">Redirect permanent "/foo/"   "http://www.example.com/bar/"</pre>


    <p>Ceci aura pour effet de rediriger tout chemin d'URL commenant par
    <code>/foo/</code> vers le mme chemin d'URL sur le serveur
    <code>www.example.com</code> en remplaant <code>/foo/</code> par
    <code>/bar/</code>. Vous pouvez rediriger les clients non seulement sur le
    serveur d'origine, mais aussi vers n'importe quel autre serveur.</p>

    <p>httpd propose aussi la directive <code class="directive"><a href="./mod/mod_alias.html#redirectmatch">RedirectMatch</a></code> pour traiter les problmes
    de rcriture d'une plus grande complexit. Par exemple, afin de rediriger
    les requtes pour la page d'accueil du site vers un site diffrent, mais
    laisser toutes les autres requtes inchanges, utilisez la
    configuration suivante :</p>

<pre class="prettyprint lang-config">RedirectMatch permanent "^/$"    "http://www.example.com/startpage.html"</pre>


    <p>De mme, pour rediriger temporairement toutes les pages d'un site
    vers une page particulire d'un autre site, utilisez ce qui suit :</p>

<pre class="prettyprint lang-config">RedirectMatch temp ".*"  "http://othersite.example.com/startpage.html"</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy" id="proxy">Mandataire inverse (Reverse Proxy)</a></h2>

<p>httpd vous permet aussi de rapatrier des documents distants
dans l'espace des URL du serveur local.
Cette technique est appele <em>mandataire inverse ou reverse
proxying</em> car le serveur web agit comme un serveur mandataire en
rapatriant les documents depuis un serveur distant puis les renvoyant
au client. Ceci diffre d'un service de mandataire usuel (direct) car, pour le client,
les documents semblent appartenir au serveur mandataire inverse.</p>

<p>Dans l'exemple suivant, quand les clients demandent des documents situs
dans le rpertoire
<code>/foo/</code>, le serveur rapatrie ces documents depuis le rpertoire
<code>/bar/</code> sur <code>internal.example.com</code>
et les renvoie au client comme s'ils appartenaient au serveur local.</p>

<pre class="prettyprint lang-config">ProxyPass "/foo/" "http://internal.example.com/bar/"
ProxyPassReverse "/foo/" "http://internal.example.com/bar/"
ProxyPassReverseCookieDomain internal.example.com public.example.com
ProxyPassReverseCookiePath "/foo/" "/bar/"</pre>


<p>La directive <code class="directive"><a href="./mod/mod_proxy.html#proxypass">ProxyPass</a></code> configure
le serveur pour rapatrier les documents appropris, alors que la directive
<code class="directive"><a href="./mod/mod_proxy.html#proxypassreverse">ProxyPassReverse</a></code>
rcrit les redirections provenant de
<code>internal.example.com</code> de telle manire qu'elles ciblent le
rpertoire appropri sur le serveur local. De manire similaire, les directives
<code class="directive"><a href="./mod/mod_proxy.html#proxypassreversecookiedomain">ProxyPassReverseCookieDomain</a></code>
et <code class="directive"><a href="./mod/mod_proxy.html#proxypassreversecookiepath">ProxyPassReverseCookiePath</a></code>
rcrivent les cookies labors par le serveur d'arrire-plan.</p>
<p>Il est important de noter cependant, que les liens situs dans les documents
ne seront pas rcrits.  Ainsi, tout lien absolu sur
<code>internal.example.com</code> fera dcrocher le client
du serveur mandataire et effectuer sa requte directement sur
<code>internal.example.com</code>. Vous pouvez modifier ces liens (et
d'utres contenus) situs dans la page au moment o elle est envoye au
client en utilisant le module <code class="module"><a href="./mod/mod_substitute.html">mod_substitute</a></code>.</p>

<pre class="prettyprint lang-config">Substitute "s/internal\.example\.com/www.example.com/i"</pre>


<p>Le module <code class="module"><a href="./mod/mod_proxy_html.html">mod_proxy_html</a></code> rend possible une rcriture plus
labore des liens en HTML et XHTML. Il permet de crer des listes
d'URLs et de leurs rcritures, de faon  pouvoir grer des scnarios
de rcriture complexes.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="rewrite" id="rewrite">Moteur de rcriture</a></h2>

    <p>Le moteur de rcriture <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> peut s'avrer
    utile lorsqu'une substitution plus puissante est ncessaire.
    Les directives fournies par ce module peuvent utiliser des caractristiques de la
    requte comme le type de navigateur ou l'adresse IP source afin de dcider
    depuis o servir le contenu. En outre, mod_rewrite peut utiliser des
    fichiers ou programmes de bases de donnes externes pour dterminer comment
    traiter une requte. Le moteur de rcriture peut effectuer les trois types
    de mise en correspondance discuts plus haut :
    redirections internes (aliases), redirections externes, et services mandataires.
    De nombreux exemples pratiques utilisant mod_rewrite sont discuts dans la
    <a href="rewrite/">documentation dtaille de mod_rewrite</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="notfound" id="notfound">Fichier non trouv (File Not Found)</a></h2>

    <p>Invitablement, apparatront des URLs qui ne correspondront  aucun
    fichier du systme de fichiers.
    Ceci peut arriver pour de nombreuses raisons.
    Il peut s'agir du dplacement de documents d'une
    localisation vers une autre. Dans ce cas, le mieux est d'utiliser la
    <a href="#redirect">redirection d'URL</a> pour informer les clients de la
    nouvelle localisation de la ressource. De cette faon, vous tes sur que
    les anciens signets et liens continueront de fonctionner, mme si la
    ressource est dplace.</p>

    <p>Une autre cause frquente d'erreurs "File Not Found" est l'erreur de
    frappe accidentelle dans les URLs, soit directement dans le navigateur,
    soit dans les liens HTML. httpd propose le module
    <code class="module"><a href="./mod/mod_speling.html">mod_speling</a></code> (sic) pour tenter de rsoudre ce problme.
    Lorsque ce module est activ, il intercepte les erreurs
    "File Not Found" et recherche une ressource possdant un nom de fichier
    similaire. Si un tel fichier est trouv, mod_speling va envoyer une
    redirection HTTP au client pour lui communiquer l'URL correcte.
    Si plusieurs fichiers proches sont trouvs, une liste des alternatives
    possibles sera prsente au client.</p>

    <p>mod_speling possde une fonctionnalit particulirement utile :
    il compare les noms de fichiers sans tenir compte de la casse.
    Ceci peut aider les systmes o les utilisateurs ne connaissent pas la
    sensibilit des URLs  la casse et bien sr les systmes de fichiers unix.
    Mais l'utilisation de mod_speling pour toute autre chose que la correction
    occasionnelle d'URLs peut augmenter la charge du serveur, car chaque
    requte "incorrecte" entrane une redirection d'URL et une nouvelle requte
    de la part du client.</p>

    <p><code class="module"><a href="./mod/mod_dir.html">mod_dir</a></code> fournit la directive <code class="directive"><a href="./mod/mod_dir.html#fallbackresource">FallbackResource</a></code> qui permet d'associer
    des URIs virtuels  une ressource relle qui peut ainsi les servir.
    Cette directive remplace avantageusement
    <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> lors de l'implmentation d'un
    "contrleur frontal".</p>

    <p>Si toutes les tentatives pour localiser le contenu
    chouent, httpd
    retourne une page d'erreur avec le code de statut HTTP 404
    (file not found). L'apparence de cette page est contrle  l'aide de la
    directive <code class="directive"><a href="./mod/core.html#errordocument">ErrorDocument</a></code>
    et peut tre personnalise de manire trs flexible comme discut dans le
    document
    <a href="custom-error.html">Rponses personnalises aux erreurs</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="other" id="other">Autres modules de mise en correspondance des
URLs</a></h2>



    <p>Les autres modules disponibles pour la mise en correspondance des
    URLs sont :</p>
    <ul>
    <li><code class="module"><a href="./mod/mod_actions.html">mod_actions</a></code> - Met une URL en correspondance
    avec un script CGI en fonction de la mthode de la requte, ou du
    type MIME de la ressource.</li>
    <li><code class="module"><a href="./mod/mod_dir.html">mod_dir</a></code> - Permet une mise en correspondance
    basique d'un slash terminal dans un fichier index comme
    <code>index.html</code>.</li>
    <li><code class="module"><a href="./mod/mod_imagemap.html">mod_imagemap</a></code> - Met en correspondance une
    requte avec une URL en fonction de la zone d'une image intgre 
    un document HTML dans laquelle un utilisateur clique.</li>
    <li><code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> - Slectionne le document
    appropri en fonction de prfrences du client telles que la langue
    ou la compression du contenu.</li>
    </ul>
    
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/urlmapping.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/urlmapping.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/urlmapping.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/urlmapping.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/urlmapping.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/urlmapping.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>