# dhcpcd is a DHCP client
# See: https://roy.marples.name/projects/dhcpcd/index

complete -c dhcpcd -l background -s b -d 'Background immediately'
complete -c dhcpcd -l script -s c -d 'Use given script'
complete -c dhcpcd -l duid -s D -d 'Generate an RFC 4361 compliant clientid'
complete -c dhcpcd -l debug -s d -d 'Echo debug messages to stderr & syslog'
complete -c dhcpcd -l lastlease -s E -d 'Use last acquired lease if cannot obtain one'
complete -c dhcpcd -l lastleaseextend -d 'Use last acquired lease if cannot obtain one even if expired'
complete -c dhcpcd -l env -s e -x -d 'Push given value the environment'
complete -c dhcpcd -l reconfigure -s g -d 'Reapply configuration for each interface'
complete -c dhcpcd -l fqdn -s F -d 'Request DHCP server to update DNS using FQDN instead of hostname'
complete -c dhcpcd -l config -s f -r -d 'Specify config to load instead of /etc/dhcpcd.conf'
complete -c dhcpcd -l hostname -s h -x -d 'Send hostname to DHCP server'
complete -c dhcpcd -l clientid -s I -x -d 'Send given clientid'
complete -c dhcpcd -l vendorclassid -s i -x -d 'Override DHCPv4 vendorclassid field sent'
complete -c dhcpcd -l logfile -s j -r -d 'Writes to specfied log file instead of syslog'
complete -c dhcpcd -l release -s k -x -d 'Release lease and de-configure interface' -a '(__fish_print_interfaces)'
complete -c dhcpcd -l leasetime -s l -x -d 'Request specific lease time in secs'
complete -c dhcpcd -l master -s M -d 'Start dhcpcd in Master mode'
complete -c dhcpcd -l metric -s m -x -d 'Set prefered interface based on given rank (lowest wins)'
complete -c dhcpcd -l rebind -s n -x -d 'Reload config and rebind specified interface' -a '(__fish_print_interfaces)'
complete -c dhcpcd -l renew -s N -x -d 'Renew existing addresses on specified interface' -a '(__fish_print_interfaces)'
complete -c dhcpcd -l option -s o -x -d 'Request DHCP option'
complete -c dhcpcd -l persistent -s p -d 'Keep configuration even when dhcpcd exits'
complete -c dhcpcd -l request -s r -x -d 'Request given address in DHCP DISCOVER message'
complete -c dhcpcd -l inform -s s -d 'Request given address in DHCP INFORM message'
complete -c dhcpcd -l inform6 -d 'Perform DHCPv6 Information Request'
complete -c dhcpcd -l static -s S -x -d 'Configure static DHCP value'
complete -c dhcpcd -l timeout -s t -x -d 'Timeout after seconds' -a '30\tDefault'
complete -c dhcpcd -l userclass -s u -x -d 'Tag DHCPv4 message with given userclass'
complete -c dhcpcd -l vendor -s v -x -d 'Add encapsulated vendor option'
complete -c dhcpcd -l version -d 'Show version and exit'
complete -c dhcpcd -s w -d 'Wait for address to be assigned before forking to background'
complete -c dhcpcd -l waitip -x -d 'Wait for address to be assigned before forking to background' -a '4\tIPv4 6\tIPv6'
complete -c dhcpcd -l exit -s x -x -d 'Exit dhcpcd process linked to given interface' -a '(__fish_print_interfaces)'
complete -c dhcpcd -l reboot -s y -x -d 'Allow reboot after secs'
