'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCard = exports.LAYOUT_ALIGNMENTS = exports.ALIGNMENTS = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _services = require('../../services');

var _text = require('../text');

var _title = require('../title');

var _beta_badge = require('../badge/beta_badge');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var textAlignToClassNameMap = {
  left: 'euiCard--leftAligned',
  center: 'euiCard--centerAligned',
  right: 'euiCard--rightAligned'
};

var ALIGNMENTS = exports.ALIGNMENTS = Object.keys(textAlignToClassNameMap);

var layoutToClassNameMap = {
  vertical: '',
  horizontal: 'euiCard--horizontal'
};

var LAYOUT_ALIGNMENTS = exports.LAYOUT_ALIGNMENTS = Object.keys(layoutToClassNameMap);
var oneOfLayouts = _propTypes2.default.oneOf(LAYOUT_ALIGNMENTS);

var cardLayout = function cardLayout(props, propName, componentName) {
  for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
    rest[_key - 3] = arguments[_key];
  }

  var oneOfResult = oneOfLayouts.apply(undefined, [props, propName, componentName].concat(rest));
  if (oneOfResult) return oneOfResult;

  if (props[propName] === 'horizontal') {
    if (props.image || props.footer) {
      return new Error(componentName + ': \'' + propName + ' = horizontal\' cannot be used in conjunction with \'image\', \'footer\', or \'textAlign\'.');
    }
  }
};

var EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
      description = _ref.description,
      title = _ref.title,
      icon = _ref.icon,
      image = _ref.image,
      footer = _ref.footer,
      onClick = _ref.onClick,
      href = _ref.href,
      rel = _ref.rel,
      target = _ref.target,
      textAlign = _ref.textAlign,
      isClickable = _ref.isClickable,
      betaBadgeLabel = _ref.betaBadgeLabel,
      betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
      betaBadgeTitle = _ref.betaBadgeTitle,
      layout = _ref.layout,
      rest = _objectWithoutProperties(_ref, ['className', 'description', 'title', 'icon', 'image', 'footer', 'onClick', 'href', 'rel', 'target', 'textAlign', 'isClickable', 'betaBadgeLabel', 'betaBadgeTooltipContent', 'betaBadgeTitle', 'layout']);

  var classes = (0, _classnames2.default)('euiCard', textAlignToClassNameMap[textAlign], layoutToClassNameMap[layout], {
    'euiCard--isClickable': onClick || href || isClickable,
    'euiCard--hasBetaBadge': betaBadgeLabel,
    'euiCard--hasIcon': icon
  }, className);

  var secureRel = void 0;
  if (href) {
    secureRel = (0, _services.getSecureRelForTarget)(target, rel);
  }

  var imageNode = void 0;
  if (image && layout === 'vertical') {
    imageNode = _react2.default.createElement('img', { className: 'euiCard__image', src: image, alt: '' });
  }

  var iconNode = void 0;
  if (icon) {
    iconNode = _react2.default.cloneElement(icon, { className: (0, _classnames2.default)(icon.props.className, 'euiCard__icon') });
  }

  var OuterElement = 'div';
  if (href) {
    OuterElement = 'a';
  } else if (onClick) {
    OuterElement = 'button';
  }

  var optionalCardTop = void 0;
  if (imageNode || iconNode) {
    optionalCardTop = _react2.default.createElement(
      'span',
      { className: 'euiCard__top' },
      imageNode,
      iconNode
    );
  }

  var optionalBetaBadge = void 0;
  if (betaBadgeLabel) {
    optionalBetaBadge = _react2.default.createElement(
      'span',
      { className: 'euiCard__betaBadgeWrapper' },
      _react2.default.createElement(_beta_badge.EuiBetaBadge, {
        label: betaBadgeLabel,
        title: betaBadgeTitle,
        tooltipContent: betaBadgeTooltipContent,
        className: 'euiCard__betaBadge'
      })
    );
  }

  return _react2.default.createElement(
    OuterElement,
    _extends({
      onClick: onClick,
      className: classes,
      href: href,
      target: target,
      rel: secureRel
    }, rest),
    optionalBetaBadge,
    optionalCardTop,
    _react2.default.createElement(
      'span',
      { className: 'euiCard__content' },
      _react2.default.createElement(
        _title.EuiTitle,
        { className: 'euiCard__title' },
        _react2.default.createElement(
          'span',
          null,
          title
        )
      ),
      _react2.default.createElement(
        _text.EuiText,
        { size: 's', className: 'euiCard__description' },
        _react2.default.createElement(
          'p',
          null,
          description
        )
      )
    ),
    layout === 'vertical' && _react2.default.createElement(
      'span',
      { className: 'euiCard__footer' },
      footer
    )
  );
};

exports.EuiCard = EuiCard;
EuiCard.propTypes = {
  className: _propTypes2.default.string,
  title: _propTypes2.default.node.isRequired,
  description: _propTypes2.default.node.isRequired,

  /**
   * Requires a <EuiIcon> node
   */
  icon: _propTypes2.default.node,

  /**
   * Accepts a url in string form
   */
  image: _propTypes2.default.string,

  /**
   * Accepts any combination of elements
   */
  footer: _propTypes2.default.node,

  /**
   * Use only if you want to forego a button in the footer and make the whole card clickable
   */
  onClick: _propTypes2.default.func,
  href: _propTypes2.default.string,
  target: _propTypes2.default.string,
  rel: _propTypes2.default.string,
  textAlign: _propTypes2.default.oneOf(ALIGNMENTS),

  /**
   * Change to "horizontal" if you need the icon to be left of the content
   */
  layout: cardLayout,

  /**
   * Add a badge to the card to label it as "Beta" or other non-GA state
   */
  betaBadgeLabel: _propTypes2.default.string,

  /**
   * Add a description to the beta badge (will appear in a tooltip)
   */
  betaBadgeTooltipContent: _propTypes2.default.node,

  /**
   * Optional title will be supplied as tooltip title or title attribute otherwise the label will be used
   */
  betaBadgeTitle: _propTypes2.default.string
};

EuiCard.defaultProps = {
  textAlign: 'center',
  layout: 'vertical'
};
EuiCard.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'title': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': ''
    },
    'description': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': ''
    },
    'icon': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Requires a <EuiIcon> node'
    },
    'image': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Accepts a url in string form'
    },
    'footer': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Accepts any combination of elements'
    },
    'onClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': 'Use only if you want to forego a button in the footer and make the whole card clickable'
    },
    'href': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'target': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'rel': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'textAlign': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '"left"',
          'computed': false
        }, {
          'value': '"center"',
          'computed': false
        }, {
          'value': '"right"',
          'computed': false
        }]
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'center\'',
        'computed': false
      }
    },
    'layout': {
      'type': {
        'name': 'custom',
        'raw': 'cardLayout'
      },
      'required': false,
      'description': 'Change to "horizontal" if you need the icon to be left of the content',
      'defaultValue': {
        'value': '\'vertical\'',
        'computed': false
      }
    },
    'betaBadgeLabel': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Add a badge to the card to label it as "Beta" or other non-GA state'
    },
    'betaBadgeTooltipContent': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Add a description to the beta badge (will appear in a tooltip)'
    },
    'betaBadgeTitle': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used'
    }
  }
}];