'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlexItem = exports.GROW_SIZES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var GROW_SIZES = exports.GROW_SIZES = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];

var EuiFlexItem = function EuiFlexItem(_ref) {
  var children = _ref.children,
      className = _ref.className,
      grow = _ref.grow,
      Component = _ref.component,
      rest = _objectWithoutProperties(_ref, ['children', 'className', 'grow', 'component']);

  var classes = (0, _classnames2.default)('euiFlexItem', _defineProperty({
    'euiFlexItem--flexGrowZero': !grow
  }, 'euiFlexItem--flexGrow' + grow, GROW_SIZES.indexOf(grow) >= 0), className);

  return _react2.default.createElement(
    Component,
    _extends({
      className: classes
    }, rest),
    children
  );
};

exports.EuiFlexItem = EuiFlexItem;
EuiFlexItem.propTypes = {
  children: _propTypes2.default.node,
  grow: growPropType,
  component: _propTypes2.default.oneOf(['div', 'span', 'figure'])
};

function growPropType(props, propName, componentName) {
  var value = props[propName];

  var validValues = [null, undefined, true, false].concat(GROW_SIZES);

  if (validValues.indexOf(value) === -1) {
    return new Error('Prop `' + propName + '` supplied to `' + componentName + '` must be a boolean or an integer between 1 and 10.');
  }
}

EuiFlexItem.defaultProps = {
  grow: true,
  component: 'div'
};
EuiFlexItem.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'grow': {
      'type': {
        'name': 'custom',
        'raw': 'growPropType'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'true',
        'computed': false
      }
    },
    'component': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '\'div\'',
          'computed': false
        }, {
          'value': '\'span\'',
          'computed': false
        }, {
          'value': '\'figure\'',
          'computed': false
        }]
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'div\'',
        'computed': false
      }
    }
  }
}];