'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPage = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var EuiPage = function EuiPage(_ref) {
  var children = _ref.children,
      className = _ref.className,
      restrictWidth = _ref.restrictWidth,
      style = _ref.style,
      rest = _objectWithoutProperties(_ref, ['children', 'className', 'restrictWidth', 'style']);

  var widthClassname = void 0;

  if (restrictWidth === true) {
    widthClassname = 'euiPage--restrictWidth-default';
  } else if (restrictWidth === false) {
    widthClassname = 'euiPage--widthIsNotRestricted';
  } else {
    widthClassname = 'euiPage--restrictWidth-custom';

    // if style has been passed as a prop, add to it
    if (style) {
      style.maxWidth = restrictWidth + 'px';
    }
    // otherwise create a new object
    else {
        style = { maxWidth: restrictWidth + 'px' };
      }
  }

  var classes = (0, _classnames2.default)('euiPage', widthClassname, className);

  return _react2.default.createElement(
    'div',
    _extends({
      className: classes,
      style: style
    }, rest),
    children
  );
};

exports.EuiPage = EuiPage;
EuiPage.propTypes = {
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,

  /**
   * Sets the max-width of the page,
   * set to `true` to use the default size,
   * set to `false` to not restrict the width,
   * set to a number for a custom width.
   */
  restrictWidth: _propTypes2.default.oneOfType([_propTypes2.default.bool, _propTypes2.default.number])
};

EuiPage.defaultProps = {
  restrictWidth: false
};
EuiPage.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'restrictWidth': {
      'type': {
        'name': 'union',
        'value': [{
          'name': 'bool'
        }, {
          'name': 'number'
        }]
      },
      'required': false,
      'description': 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width.',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    }
  }
}];