'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHorizontalBarSeries = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _visualization_color_type = require('../utils/visualization_color_type');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiHorizontalBarSeries = exports.EuiHorizontalBarSeries = function (_HorizontalBarSeries) {
  _inherits(EuiHorizontalBarSeries, _HorizontalBarSeries);

  function EuiHorizontalBarSeries() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, EuiHorizontalBarSeries);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = EuiHorizontalBarSeries.__proto__ || Object.getPrototypeOf(EuiHorizontalBarSeries)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      isMouseOverValue: false
    }, _this._onValueMouseOver = function () {
      _this.setState(function () {
        return { isMouseOverValue: true };
      });
    }, _this._onValueMouseOut = function () {
      _this.setState(function () {
        return { isMouseOverValue: false };
      });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(EuiHorizontalBarSeries, [{
    key: 'render',
    value: function render() {
      var isMouseOverValue = this.state.isMouseOverValue;

      var _props = this.props,
          name = _props.name,
          data = _props.data,
          color = _props.color,
          onValueClick = _props.onValueClick,
          rest = _objectWithoutProperties(_props, ['name', 'data', 'color', 'onValueClick']);

      var isHighDataVolume = data.length > 80 ? true : false;
      var classes = (0, _classnames2.default)('euiBarSeries', isHighDataVolume && 'euiBarSeries--highDataVolume', isMouseOverValue && onValueClick && 'euiBarSeries--hoverEnabled');
      return _react2.default.createElement(_reactVis.HorizontalBarSeries, _extends({
        key: name,
        className: classes,
        onValueClick: onValueClick,
        onValueMouseOver: this._onValueMouseOver,
        onValueMouseOut: this._onValueMouseOut,
        color: color,
        data: data
      }, rest));
    }
  }]);

  return EuiHorizontalBarSeries;
}(_reactVis.HorizontalBarSeries);

EuiHorizontalBarSeries.displayName = 'EuiHorizontalBarSeries';

EuiHorizontalBarSeries.propTypes = {
  /** The name used to define the data in tooltips and legends */
  name: _propTypes2.default.string.isRequired,
  /** Array<{x: number, y: string|number}> */
  data: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    x: _propTypes2.default.number,
    y: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number])
  })).isRequired,
  /** An EUI visualization color, the default value is enforced by EuiXYChart */
  color: _visualization_color_type.VisualizationColorType,
  /**
   * Callback when clicking on a bar. Returns { x, y } object.
   */
  onValueClick: _propTypes2.default.func
};

EuiHorizontalBarSeries.defaultProps = {};
EuiHorizontalBarSeries.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiHorizontalBarSeries',
  'methods': [{
    'name': '_onValueMouseOver',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': '_onValueMouseOut',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }],
  'props': {
    'name': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': 'The name used to define the data in tooltips and legends'
    },
    'data': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'x': {
              'name': 'number',
              'required': false
            },
            'y': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            }
          }
        }
      },
      'required': true,
      'description': 'Array<{x: number, y: string|number}>'
    },
    'color': {
      'type': {
        'name': 'custom',
        'raw': 'VisualizationColorType'
      },
      'required': false,
      'description': 'An EUI visualization color, the default value is enforced by EuiXYChart'
    },
    'onValueClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': 'Callback when clicking on a bar. Returns { x, y } object.'
    }
  }
}];