"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var mixins = require("./mixins");
var fielddef_1 = require("../../fielddef");
var type_1 = require("../../type");
exports.geoshape = {
    vgMark: 'shape',
    encodeEntry: function (model) {
        return tslib_1.__assign({}, mixins.baseEncodeEntry(model, { size: 'ignore', orient: 'ignore' }));
    },
    postEncodingTransform: function (model) {
        var encoding = model.encoding;
        var shapeDef = encoding.shape;
        var transform = tslib_1.__assign({ type: 'geoshape', projection: model.projectionName() }, (shapeDef && fielddef_1.isFieldDef(shapeDef) && shapeDef.type === type_1.GEOJSON ? { field: fielddef_1.vgField(shapeDef, { expr: 'datum' }) } : {}));
        return [transform];
    }
};
//# sourceMappingURL=data:application/json;base64,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