/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class IterateStructuralProcessStep {
    protected IterateStructuralProcessStep() {
    }

    protected void startProcessing(RenderNode renderNode) {
        if (renderNode instanceof InlineRenderBox) {
            InlineRenderBox inlineRenderBox = (InlineRenderBox)renderNode;
            if (this.startInlineBox(inlineRenderBox)) {
                this.processBoxChilds(inlineRenderBox);
            }
            this.finishInlineBox(inlineRenderBox);
        } else if (renderNode instanceof NormalFlowRenderBox) {
            NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)renderNode;
            this.startNormalFlow(normalFlowRenderBox);
            NormalFlowRenderBox[] normalFlowRenderBoxArray = normalFlowRenderBox.getFlows();
            for (int i = 0; i < normalFlowRenderBoxArray.length; ++i) {
                NormalFlowRenderBox normalFlowRenderBox2 = normalFlowRenderBoxArray[i];
                this.startProcessing(normalFlowRenderBox2);
            }
            this.processBoxChilds(normalFlowRenderBox);
            this.finishNormalFlow(normalFlowRenderBox);
        } else if (renderNode instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderNode;
            if (this.startBlockBox(paragraphRenderBox)) {
                this.processParagraphChilds(paragraphRenderBox);
            }
            this.finishBlockBox(paragraphRenderBox);
        } else if (renderNode instanceof LogicalPageBox) {
            LogicalPageBox logicalPageBox = (LogicalPageBox)renderNode;
            if (this.startBlockBox(logicalPageBox)) {
                this.startProcessing(logicalPageBox.getHeaderArea());
                this.processBoxChilds(logicalPageBox);
                this.startProcessing(logicalPageBox.getFooterArea());
            }
            this.finishBlockBox(logicalPageBox);
        } else if (renderNode instanceof BlockRenderBox) {
            BlockRenderBox blockRenderBox = (BlockRenderBox)renderNode;
            if (this.startBlockBox(blockRenderBox)) {
                this.processBoxChilds(blockRenderBox);
            }
            this.finishBlockBox(blockRenderBox);
        } else if (renderNode instanceof RenderBox) {
            RenderBox renderBox = (RenderBox)renderNode;
            this.startOtherBox(renderBox);
            this.processBoxChilds(renderBox);
            this.finishOtherBox(renderBox);
        } else {
            this.startOtherNode(renderNode);
            this.finishOtherNode(renderNode);
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        this.processBoxChilds(paragraphRenderBox.getPool());
    }

    protected void finishNormalFlow(NormalFlowRenderBox normalFlowRenderBox) {
    }

    protected void startNormalFlow(NormalFlowRenderBox normalFlowRenderBox) {
    }

    protected void processBoxChilds(RenderBox renderBox) {
        for (RenderNode renderNode = renderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            this.startProcessing(renderNode);
        }
    }

    protected void startOtherNode(RenderNode renderNode) {
    }

    protected void finishOtherNode(RenderNode renderNode) {
    }

    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        return true;
    }

    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
    }

    protected boolean startInlineBox(InlineRenderBox inlineRenderBox) {
        return true;
    }

    protected void finishInlineBox(InlineRenderBox inlineRenderBox) {
    }

    protected boolean startOtherBox(RenderBox renderBox) {
        return true;
    }

    protected void finishOtherBox(RenderBox renderBox) {
    }
}

