/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.realm;

import java.io.Serializable;
import java.util.LinkedHashMap;
import net.jradius.exception.RadiusException;
import net.jradius.realm.JRadiusRealm;
import net.jradius.realm.RealmFactory;

public class JRadiusRealmManager {
    private static JRadiusRealmManager defaultManager = new JRadiusRealmManager();
    private LinkedHashMap<String, RealmFactory> factories = new LinkedHashMap();

    public static JRadiusRealmManager getManager() {
        return defaultManager;
    }

    public void setRealmFactory(String name, RealmFactory factory) {
        this.factories.put(name, factory);
    }

    public RealmFactory getRealmFactory(Serializable name) {
        RealmFactory factory = this.factories.get(name);
        if (factory == null && name != null) {
            factory = this.factories.get(null);
        }
        return factory;
    }

    public JRadiusRealm getRealm(String realm) throws RadiusException {
        for (RealmFactory factory : this.factories.values()) {
            JRadiusRealm r = factory.getRealm(realm);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static JRadiusRealm get(String requestor, String realm) throws RadiusException {
        return defaultManager.getRealmFactory((Serializable)((Object)requestor)).getRealm(realm);
    }

    public static JRadiusRealm get(String realm) throws RadiusException {
        return defaultManager.getRealm(realm);
    }
}

