/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop.concurrency;

import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;

public class NonstopSync
implements Sync {
    private final NonstopStore nonstopStore;
    private final Sync delegateSync;

    public NonstopSync(NonstopStore nonstopStore, Sync delegateSync) {
        this.nonstopStore = nonstopStore;
        this.delegateSync = delegateSync;
    }

    public boolean isHeldByCurrentThread(final LockType type) {
        return this.nonstopStore.executeClusterOperation(new ClusterOperation<Boolean>(){

            @Override
            public Boolean performClusterOperation() {
                return NonstopSync.this.delegateSync.isHeldByCurrentThread(type);
            }

            @Override
            public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                switch (configuredTimeoutBehavior) {
                    case EXCEPTION: {
                        throw new NonStopCacheException("isHeldByCurrentThread timed out");
                    }
                    case LOCAL_READS: 
                    case NOOP: {
                        return false;
                    }
                }
                throw new NonStopCacheException("unknown nonstop timeout behavior type: " + (Object)((Object)configuredTimeoutBehavior));
            }
        });
    }

    public void lock(final LockType type) {
        this.nonstopStore.executeClusterOperation(new ClusterOperation<Void>(){

            @Override
            public Void performClusterOperation() {
                NonstopSync.this.delegateSync.lock(type);
                return null;
            }

            @Override
            public Void performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                switch (configuredTimeoutBehavior) {
                    case EXCEPTION: {
                        throw new NonStopCacheException("lock timed out");
                    }
                    case LOCAL_READS: 
                    case NOOP: {
                        return null;
                    }
                }
                throw new NonStopCacheException("unknown nonstop timeout behavior type: " + (Object)((Object)configuredTimeoutBehavior));
            }
        });
    }

    public boolean tryLock(final LockType type, final long msec) throws InterruptedException {
        return this.nonstopStore.executeClusterOperation(new ClusterOperation<Boolean>(){

            @Override
            public Boolean performClusterOperation() throws Exception {
                return NonstopSync.this.delegateSync.tryLock(type, msec);
            }

            @Override
            public Boolean performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                switch (configuredTimeoutBehavior) {
                    case EXCEPTION: {
                        throw new NonStopCacheException("tryLock timed out");
                    }
                    case LOCAL_READS: 
                    case NOOP: {
                        return false;
                    }
                }
                throw new NonStopCacheException("unknown nonstop timeout behavior type: " + (Object)((Object)configuredTimeoutBehavior));
            }
        });
    }

    public void unlock(final LockType type) {
        this.nonstopStore.executeClusterOperation(new ClusterOperation<Void>(){

            @Override
            public Void performClusterOperation() {
                NonstopSync.this.delegateSync.unlock(type);
                return null;
            }

            @Override
            public Void performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
                switch (configuredTimeoutBehavior) {
                    case EXCEPTION: {
                        throw new NonStopCacheException("unlock timed out");
                    }
                    case LOCAL_READS: 
                    case NOOP: {
                        return null;
                    }
                }
                throw new NonStopCacheException("unknown nonstop timeout behavior type: " + (Object)((Object)configuredTimeoutBehavior));
            }
        });
    }
}

