/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore
implements Store {
    private transient List<StoreListener> listenerList;

    protected synchronized List<StoreListener> getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<StoreListener>();
        }
        return this.listenerList;
    }

    @Override
    public boolean isCacheCoherent() {
        return false;
    }

    @Override
    public boolean isClusterCoherent() {
        return false;
    }

    @Override
    public boolean isNodeCoherent() {
        return false;
    }

    @Override
    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void waitUntilClusterCoherent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void addStoreListener(StoreListener listener) {
        this.removeStoreListener(listener);
        this.getEventListenerList().add(listener);
    }

    @Override
    public synchronized void removeStoreListener(StoreListener listener) {
        this.getEventListenerList().remove(listener);
    }

    public void fireNodeCoherent(boolean nodeCoherent) {
        List<StoreListener> listeners = this.getEventListenerList();
        for (StoreListener listener : listeners) {
            listener.nodeCoherent(nodeCoherent);
        }
    }

    public void fireClusterCoherent(boolean clusterCoherent) {
        List<StoreListener> listeners = this.getEventListenerList();
        for (StoreListener listener : listeners) {
            listener.clusterCoherent(clusterCoherent);
        }
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        if (!extractors.isEmpty()) {
            throw new InvalidConfigurationException("Search attributes not supported by this store type: " + this.getClass().getName());
        }
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        throw new UnsupportedOperationException("Query execution not supported by this store type: " + this.getClass().getName());
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        return null;
    }
}

