/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.DiscoverDeviceTypeTask;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class ScanSubnetsTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(ScanSubnetsTask.class);
    private Set<Network4Address> subnets;
    private Domain domain;

    protected ScanSubnetsTask() {
    }

    public ScanSubnetsTask(Set<Network4Address> subnets, Domain domain, String comments, String target, String author) {
        super(comments, target, author);
        this.domain = domain;
        this.subnets = subnets;
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Subnet scan";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List knownCommunities;
        logger.debug("Starting scan subnet process.");
        HashSet<Integer> toScan = new HashSet<Integer>();
        try (Session session = Database.getSession();){
            try {
                for (Network4Address subnet : this.subnets) {
                    int max;
                    int address2;
                    int address1 = subnet.getSubnetMin();
                    int min = address1 > (address2 = subnet.getSubnetMax()) ? address2 : address1;
                    int n = max = address1 > address2 ? address1 : address2;
                    if (min < max - 1) {
                        ++min;
                        --max;
                    }
                    logger.trace("Will scan from {} to {}.", (Object)min, (Object)max);
                    this.logIt(String.format("Will scan %s (from %d to %d)", subnet.getPrefix(), min, max), 5);
                    List existing = session.createQuery("select d.mgmtAddress.address from Device d where d.mgmtAddress.address >= :min and d.mgmtAddress.address <= :max").setInteger("min", min).setInteger("max", max).list();
                    for (int a = min; a <= max; ++a) {
                        if (existing.contains(a)) continue;
                        toScan.add(a);
                    }
                }
            }
            catch (HibernateException e) {
                logger.error("Error while retrieving the existing devices in the scope.", e);
                this.logIt("Error while checking the existing devices.", 1);
                this.status = Task.Status.FAILURE;
                session.close();
                return;
            }
            try {
                knownCommunities = session.createQuery("from DeviceSnmpCommunity c where c.mgmtDomain is null or c.mgmtDomain = :domain").setEntity("domain", (Object)this.domain).list();
            }
            catch (Exception e) {
                logger.error("Error while retrieving the communities.", e);
                this.logIt("Error while getting the communities.", 1);
                this.status = Task.Status.FAILURE;
                session.close();
                return;
            }
        }
        if (knownCommunities.size() == 0) {
            logger.error("No available SNMP community to scan devices.");
            this.logIt("No available SNMP community to scan devices.", 1);
            this.status = Task.Status.FAILURE;
            return;
        }
        logger.trace("Will try {} SNMP communities.", (Object)knownCommunities.size());
        Iterator<Network4Address> iterator = toScan.iterator();
        while (iterator.hasNext()) {
            int a = (Integer)((Object)iterator.next());
            try {
                Network4Address address = new Network4Address(a, 32);
                if (!address.isNormalUnicast()) {
                    logger.trace("Bad address {} skipped.", (Object)a);
                    this.logIt(String.format("Skipping %s.", address.getIp()), 4);
                    continue;
                }
                this.logIt("Adding a task to scan " + address.getIp(), 5);
                logger.trace("Will add a discovery task for device with IP {} ({}).", (Object)a, (Object)address.getIp());
                DiscoverDeviceTypeTask discoverTask = new DiscoverDeviceTypeTask(address, this.getDomain(), this.comments, this.author);
                for (DeviceCredentialSet credentialSet : knownCommunities) {
                    discoverTask.addCredentialSet(credentialSet);
                }
                TaskManager.addTask(discoverTask);
            }
            catch (Exception e) {
                logger.error("Error while adding discovery task.", e);
                this.logIt("Error while adding discover device type: " + e.getMessage(), 2);
            }
        }
        this.status = Task.Status.SUCCESS;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScanSubnetsTask task = (ScanSubnetsTask)super.clone();
        task.setSubnets(this.subnets);
        return task;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    public Set<Network4Address> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Set<Network4Address> subnets) {
        this.subnets = subnets;
    }
}

