/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class RstStreamFrame
extends SpdyFrame {
    private static final ThreadCache.CachedTypeIndex<RstStreamFrame> CACHE_IDX = ThreadCache.obtainIndex(RstStreamFrame.class, 8);
    public static final int TYPE = 3;
    public static final int PROTOCOL_ERROR = 1;
    public static final int INVALID_STREAM = 2;
    public static final int REFUSED_STREAM = 3;
    public static final int UNSUPPORTED_VERSION = 4;
    public static final int CANCEL = 5;
    public static final int INTERNAL_ERROR = 6;
    public static final int FLOW_CONTROL_ERROR = 7;
    public static final int STREAM_IN_USE = 8;
    public static final int STREAM_ALREADY_CLOSED = 9;
    public static final int INVALID_CREDENTIALS = 10;
    public static final int FRAME_TOO_LARGE = 11;
    private int streamId;
    private int statusCode;

    private RstStreamFrame() {
    }

    static RstStreamFrame create() {
        RstStreamFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new RstStreamFrame();
        }
        return frame;
    }

    static RstStreamFrame create(SpdyHeader header) {
        RstStreamFrame frame = RstStreamFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static RstStreamFrameBuilder builder() {
        return new RstStreamFrameBuilder();
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isFlagSet(byte flag) {
        return false;
    }

    @Override
    public void setFlag(byte flag) {
    }

    @Override
    public void clearFlag(byte flag) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RstStreamFrame");
        sb.append("{streamId=").append(this.streamId);
        sb.append(", statusCode=").append(this.statusCode);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.streamId = 0;
        this.statusCode = 0;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Object frameBuffer = memoryManager.allocate(16);
        frameBuffer.putInt(-2147287037);
        frameBuffer.putInt(8);
        frameBuffer.putInt(this.streamId & Integer.MAX_VALUE);
        frameBuffer.putInt(this.statusCode);
        frameBuffer.trim();
        return frameBuffer;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.streamId = header.buffer.getInt() & Integer.MAX_VALUE;
        this.statusCode = header.buffer.getInt();
    }

    public static class RstStreamFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<RstStreamFrameBuilder> {
        private final RstStreamFrame rstStreamFrame;

        protected RstStreamFrameBuilder() {
            super(RstStreamFrame.create());
            this.rstStreamFrame = (RstStreamFrame)this.frame;
        }

        public RstStreamFrameBuilder streamId(int streamId) {
            this.rstStreamFrame.streamId = streamId;
            return this;
        }

        public RstStreamFrameBuilder statusCode(int statusCode) {
            this.rstStreamFrame.statusCode = statusCode;
            return this;
        }

        public RstStreamFrame build() {
            return this.rstStreamFrame;
        }

        @Override
        protected RstStreamFrameBuilder getThis() {
            return this;
        }
    }
}

