/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.frames.workspace;

import com.projity.pm.graphic.frames.workspace.FrameManager;
import com.projity.pm.graphic.frames.workspace.NamedFrameEvent;
import com.projity.pm.graphic.frames.workspace.NamedFrameListener;
import java.awt.Container;
import java.awt.HeadlessException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.apache.commons.collections.Closure;

public abstract class NamedFrame
extends JPanel {
    private boolean showTitleBar = true;
    private String tabTitle = null;
    private String id = null;
    private boolean active;
    protected EventListenerList listenerList = new EventListenerList();
    private FrameManager manager;

    public NamedFrame(String string, ImageIcon imageIcon) throws HeadlessException {
        this.id = string;
        this.setBorder(null);
    }

    public Container getContentPane() {
        return this;
    }

    public final boolean isShowTitleBar() {
        return this.showTitleBar;
    }

    public final void setShowTitleBar(boolean bl) {
        this.showTitleBar = bl;
    }

    public void setTabTitle(String string) {
        this.tabTitle = string;
        if (this.manager != null) {
            this.manager.setTabTitle(this, string);
        }
    }

    public String getTitle() {
        return this.tabTitle;
    }

    public void removeNamedFrameListener(NamedFrameListener namedFrameListener) {
        this.listenerList.remove(NamedFrameListener.class, namedFrameListener);
    }

    public void addNamedFrameListener(NamedFrameListener namedFrameListener) {
        this.listenerList.add(NamedFrameListener.class, namedFrameListener);
    }

    public void fireNamedFrameActivated(final NamedFrameEvent namedFrameEvent) {
        this.fire(namedFrameEvent, new Closure(){

            @Override
            public void execute(Object object) {
                ((NamedFrameListener)object).namedFrameActivated(namedFrameEvent);
            }
        });
    }

    public void fireNamedFrameTabShown(final NamedFrameEvent namedFrameEvent) {
        this.fire(namedFrameEvent, new Closure(){

            @Override
            public void execute(Object object) {
                ((NamedFrameListener)object).namedFrameShown(namedFrameEvent);
            }
        });
    }

    private void fire(NamedFrameEvent namedFrameEvent, Closure closure) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != NamedFrameListener.class) continue;
            closure.execute((NamedFrameListener)objectArray[i + 1]);
        }
    }

    final String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public final boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setManager(FrameManager frameManager) {
        this.manager = frameManager;
    }

    @Override
    public String toString() {
        return this.tabTitle;
    }
}

