/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.laf;

import com.projity.graphic.configuration.shape.Colors;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.graphic.laf.LafManager;
import com.projity.util.Environment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;

public class LafManagerImpl
implements LafManager {
    protected static LookAndFeel plaf = null;
    protected static GraphicManager graphicManager;
    private static Boolean lafOK;

    public LafManagerImpl(GraphicManager graphicManager) {
        LafManagerImpl.graphicManager = graphicManager;
    }

    @Override
    public void clean() {
        if (plaf != null) {
            plaf.uninitialize();
            plaf = null;
        }
    }

    public static boolean isLafOk() {
        if (lafOK == null) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            Object object = uIDefaults.get("ClassLoader");
            JPanel jPanel = new JPanel();
            ClassLoader classLoader = object != null ? (ClassLoader)object : jPanel.getClass().getClassLoader();
            Class<? extends ComponentUI> clazz = uIDefaults.getUIClass(jPanel.getUIClassID(), classLoader);
            lafOK = clazz != null;
        }
        return lafOK;
    }

    @Override
    public LookAndFeel getPlaf() {
        if (plaf == null) {
            try {
                int n = Environment.getOs();
                if (n != Environment.LINUX) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    plaf = UIManager.getLookAndFeel();
                    return plaf;
                }
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                plaf = UIManager.getLookAndFeel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (graphicManager != null) {
                SwingUtilities.updateComponentTreeUI(graphicManager.getContainer());
            }
        }
        return plaf;
    }

    @Override
    public void initLookAndFeel() {
        if (plaf == null) {
            this.getPlaf();
        }
    }

    @Override
    public void setColorTheme(String string) {
    }

    @Override
    public void changePalette() {
    }

    @Override
    public boolean isChangePaletteAllowed(LookAndFeel lookAndFeel) {
        return false;
    }

    @Override
    public void paintComponent(Graphics graphics, Component component, boolean bl) {
        if (Environment.isMac()) {
            graphics.setColor(GraphicManager.getInstance().getLafManager().getUnselectedBackgroundColor());
            Rectangle rectangle = component.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void setUI(JTabbedPane jTabbedPane) {
    }

    @Override
    public void setColorScheme(JComponent jComponent) {
    }

    @Override
    public void paintTimeScale(Graphics2D graphics2D, int n, int n2, int n3, int n4, Shape[] shapeArray) {
    }

    @Override
    public Color getSelectedBackgroundColor() {
        return Environment.isMac() ? Colors.NOT_TOO_DARK_GRAY : Color.DARK_GRAY;
    }

    @Override
    public Color getUnselectedBackgroundColor() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (Environment.isMac()) {
            return Environment.isMac() ? Colors.VERY_LIGHT_GRAY : lookAndFeel.getDefaults().getColor("TableHeader.background");
        }
        return lookAndFeel.getDefaults().getColor("TableHeader.focusCellForeground");
    }

    @Override
    public void dumpUIValues() {
        String[] stringArray = new String[]{"Label.background", "Table.focusCellBackground", "Menu.selectionBackground", "Table.focusCellBackground", "TabbedPane.darkShadow", "Table.focusCellForeground", "Table.selectionBackground", "TableHeader.background", "TextField.selectionBackground"};
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i] + "=" + UIManager.get(stringArray[i]));
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        System.out.println("windows laf" + LafManagerImpl.isWindowsLAF());
        System.out.println("LAF : " + UIManager.getLookAndFeel().getClass().getName());
        LafManagerImpl.outputSwingDefs();
    }

    public static void outputSwingDefs() {
        String string = System.getProperty("line.separator");
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            String string2 = "KEY: " + k + ", VALUE: " + object + string;
            System.out.println(string2);
        }
    }

    public static boolean isWindowsLAF() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    @Override
    public boolean isToolbarOpaque() {
        return Environment.isNewLaf() || LafManagerImpl.isWindowsLAF();
    }

    static {
        lafOK = null;
    }
}

