/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.datatype.CanSupplyRateUnit;
import com.projity.datatype.RateFormat;
import com.projity.field.Field;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.renderer.SimpleRenderer;
import java.awt.Component;
import java.text.Format;
import javax.swing.JLabel;
import javax.swing.JTable;

public class RateRenderer
extends SimpleRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object != null) {
            jLabel.setText(RateRenderer.getFormat(jTable, n, n2).format(object));
        }
        return jLabel;
    }

    public static Format getFormat(JTable jTable, int n, int n2) {
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)jTable.getModel();
        Object object = spreadSheetModel.getObjectInRow(n);
        Field field = spreadSheetModel.getFieldInColumn(n2 + 1);
        boolean bl = true;
        if (object instanceof CanSupplyRateUnit) {
            bl = ((CanSupplyRateUnit)object).getTimeUnitLabel() == null;
        }
        return RateFormat.getInstance(object, field.isMoney(), bl && field.isPercent(), bl);
    }

    @Override
    public Component getComponent(Object object, GraphicNode graphicNode, Field field, SpreadSheetParams spreadSheetParams) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(null, object, false, false, -1, -1);
        if (object != null) {
            Object object2 = graphicNode.getNode().getImpl();
            boolean bl = true;
            if (object2 instanceof CanSupplyRateUnit) {
                bl = ((CanSupplyRateUnit)object2).getTimeUnitLabel() == null;
            }
            jLabel.setText(RateFormat.getInstance(object2, field.isMoney(), bl && field.isPercent(), bl).format(object));
        }
        return jLabel;
    }
}

