/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionList
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Instruction> all = new ArrayList<Instruction>();
    private final Swimlane defaultSwimlane;
    private LinkRendering outlinkRendering;

    public InstructionList() {
        this(null);
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public boolean isOnlySingleStop() {
        return this.all.size() == 1 && this.getLast() instanceof InstructionStop && !((InstructionStop)this.getLast()).hasNotes();
    }

    public InstructionList(Swimlane defaultSwimlane) {
        this.defaultSwimlane = defaultSwimlane;
    }

    @Override
    public void add(Instruction ins) {
        this.all.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        if (this.all.size() == 0) {
            return new FtileEmpty(factory.skinParam(), this.defaultSwimlane);
        }
        ArrayList<WeldingPoint> breaks = new ArrayList<WeldingPoint>();
        Ftile result = this.eventuallyAddNote(factory, null, this.getSwimlaneIn());
        for (Instruction ins : this.all) {
            Ftile cur = ins.createFtile(factory);
            breaks.addAll(cur.getWeldingPoints());
            if (!ins.getInLinkRendering().isNone()) {
                cur = factory.decorateIn(cur, ins.getInLinkRendering());
            }
            if (result == null) {
                result = cur;
                continue;
            }
            result = factory.assembly(result, cur);
        }
        if (this.outlinkRendering != null) {
            result = factory.decorateOut(result, this.outlinkRendering);
        }
        if (breaks.size() > 0) {
            result = new FtileDecorateWelding(result, breaks);
        }
        return result;
    }

    @Override
    public final boolean kill() {
        if (this.all.size() == 0) {
            return false;
        }
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.all.iterator().next().getInLinkRendering();
    }

    @Override
    public Instruction getLast() {
        if (this.all.size() == 0) {
            return null;
        }
        return this.all.get(this.all.size() - 1);
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.getLast() == null) {
            return super.addNote(note, position, type, colors, swimlaneNote);
        }
        return this.getLast().addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.all);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.defaultSwimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        Set<Swimlane> swimlanes = this.getSwimlanes();
        if (swimlanes.size() == 0) {
            return null;
        }
        if (swimlanes.size() == 1) {
            return swimlanes.iterator().next();
        }
        return this.getLast().getSwimlaneOut();
    }

    public static Set<Swimlane> getSwimlanes2(List<? extends Instruction> list) {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        for (Instruction instruction : list) {
            result.addAll(instruction.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    public void setOutRendering(LinkRendering outlinkRendering) {
        this.outlinkRendering = outlinkRendering;
    }
}

