/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.InstantArithmetic;

class BasicInstantArithmetic
implements InstantArithmetic {
    private final DayClose dayClose;

    BasicInstantArithmetic(DayClose dayClose) {
        if (dayClose == null) {
            throw new IllegalArgumentException();
        }
        this.dayClose = dayClose;
    }

    @Override
    public Instant add(Instant i1, Duration duration) {
        Instant result = i1;
        long min = duration.getMinutes();
        if (min < 0L) {
            throw new IllegalArgumentException();
        }
        for (long i = 0L; i < min; i += 86400L) {
            result = result.next(this.dayClose);
        }
        return result;
    }

    @Override
    public Instant sub(Instant i1, Duration duration) {
        Instant result = i1;
        long min = duration.getMinutes();
        if (min < 0L) {
            throw new IllegalArgumentException();
        }
        for (long i = 0L; i < min; i += 86400L) {
            result = result.prev(this.dayClose);
        }
        return result;
    }

    @Override
    public Duration diff(Instant i1, Instant i2) {
        if (i2.compareTo(i1) < 0) {
            throw new IllegalArgumentException();
        }
        long minutes = 0L;
        while (i2.compareTo(i1) > 0) {
            minutes += 86400L;
            i1 = i1.next(null);
        }
        return new Duration(minutes);
    }
}

