/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeHeaderDay
extends AbstractTextBlock
implements TextBlock {
    private final Day start;
    private final Day end;
    private final TimeLine timeline;
    private final double dayWidth;
    private final UFont font = UFont.serif(9);
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public TimeHeaderDay(Day start, Day end, TimeLine timeline, double dayWidth) {
        this.start = start;
        this.end = end;
        this.timeline = timeline;
        this.dayWidth = dayWidth;
    }

    @Override
    public void drawU(UGraphic ug) {
        int n = 0;
        Day d = this.start;
        while (d.compareTo(this.end) <= 0) {
            String text = "" + d.getNumDay();
            TextBlock b = Display.create(text).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dimText = b.calculateDimension(ug.getStringBounder());
            double diffX = this.dayWidth - dimText.getWidth();
            double diffY = this.getHeight() - dimText.getHeight();
            ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
            ug = ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
            ug.apply(new UTranslate((double)n * this.dayWidth, 0.0)).draw(new URectangle(this.dayWidth, this.getHeight()));
            b.drawU(ug.apply(new UTranslate((double)n * this.dayWidth + diffX / 2.0, diffY / 2.0)));
            ++n;
            d = (Day)this.timeline.next(d);
        }
    }

    private double getHeight() {
        return 20.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = 0;
        Day d = this.start;
        while (d.compareTo(this.end) <= 0) {
            ++n;
            d = (Day)this.timeline.next(d);
        }
        return new Dimension2DDouble((double)n * this.dayWidth, this.getHeight());
    }
}

