/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDraw
implements UDrawable {
    private final Task task;
    private final TimeScale timeScale;
    private final double y;
    private ComplementColors colors;
    private final double margin = 2.0;

    public TaskDraw(Task task, TimeScale timeScale, double y) {
        this.y = y;
        this.task = task;
        this.timeScale = timeScale;
    }

    public TextBlock getTitle() {
        return this.task.getCode().getSimpleDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug) {
        double start = this.timeScale.getStartingPosition(this.task.getStart());
        UShape rect = this.getShape();
        ug = this.applyColors(ug);
        ug.apply(new UTranslate(start + 2.0, 2.0)).draw(rect);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        if (this.isDiamond()) {
            return ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        }
        return ug.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(HtmlColorUtils.COL_84BE84));
    }

    private UShape getShape() {
        if (this.isDiamond()) {
            return this.getDiamond();
        }
        Instant instantStart = this.task.getStart();
        Instant instantEnd = this.task.getEnd();
        double start = this.timeScale.getStartingPosition(instantStart);
        double end = this.timeScale.getStartingPosition(instantEnd.increment());
        return new URectangle(end - start - 4.0, this.getHeight() - 4.0, 8.0, 8.0);
    }

    private boolean isDiamond() {
        Instant instantEnd;
        Instant instantStart = this.task.getStart();
        return instantStart.compareTo(instantEnd = this.task.getEnd()) == 0;
    }

    private UShape getDiamond() {
        double h = this.getHeight() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }

    public double getHeight() {
        return 16.0;
    }

    public double getY() {
        return this.y;
    }

    public double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.y;
        }
        if (direction == Direction.DOWN) {
            return this.y + this.getHeight();
        }
        return this.y + this.getHeight() / 2.0;
    }

    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }
}

