/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DayOfWeek;
import net.sourceforge.plantuml.project3.GCalendar;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.TimeScale;

public class TimeScaleWithoutWeekEnd
implements TimeScale {
    private final double scale = 16.0;
    private final GCalendar calendar;

    public TimeScaleWithoutWeekEnd(GCalendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException();
        }
        this.calendar = calendar;
    }

    @Override
    public double getStartingPosition(Instant instant) {
        double result = 0.0;
        InstantDay current = (InstantDay)instant;
        while (current.getNumDay() > 0) {
            current = current.decrement();
            result += this.getWidth(current);
        }
        return result;
    }

    @Override
    public double getWidth(Instant instant) {
        DayAsDate day = this.calendar.toDayAsDate((InstantDay)instant);
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            return 1.0;
        }
        return 16.0;
    }
}

