/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.DataSourceImpl;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;
import net.sourceforge.plantuml.salt.factory.ElementFactory;
import net.sourceforge.plantuml.salt.factory.ElementFactoryBorder;
import net.sourceforge.plantuml.salt.factory.ElementFactoryButton;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryCheckboxOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryDroplist;
import net.sourceforge.plantuml.salt.factory.ElementFactoryImage;
import net.sourceforge.plantuml.salt.factory.ElementFactoryLine;
import net.sourceforge.plantuml.salt.factory.ElementFactoryMenu;
import net.sourceforge.plantuml.salt.factory.ElementFactoryPyramid;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOff;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRadioOn;
import net.sourceforge.plantuml.salt.factory.ElementFactoryRetrieveFromDictonnary;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTab;
import net.sourceforge.plantuml.salt.factory.ElementFactoryText;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTextField;
import net.sourceforge.plantuml.salt.factory.ElementFactoryTree;

public class SaltUtils {
    public static Element createElement(List<String> data) {
        DataSourceImpl source = new DataSourceImpl(data);
        ArrayList<AbstractElementFactoryComplex> cpx = new ArrayList<AbstractElementFactoryComplex>();
        Dictionary dictionary = new Dictionary();
        cpx.add(new ElementFactoryPyramid(source, dictionary));
        cpx.add(new ElementFactoryBorder(source, dictionary));
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            SaltUtils.addSimpleFactory(abstractElementFactoryComplex, source, dictionary);
        }
        for (AbstractElementFactoryComplex abstractElementFactoryComplex : cpx) {
            for (AbstractElementFactoryComplex f2 : cpx) {
                abstractElementFactoryComplex.addFactory(f2);
            }
        }
        for (ElementFactory elementFactory : cpx) {
            if (!elementFactory.ready()) continue;
            Log.info("Using " + elementFactory);
            return elementFactory.create().getElement();
        }
        Log.println("data=" + data);
        throw new IllegalArgumentException();
    }

    private static void addSimpleFactory(AbstractElementFactoryComplex cpxFactory, DataSource source, Dictionary dictionary) {
        cpxFactory.addFactory(new ElementFactoryMenu(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryTree(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryTab(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryLine(source));
        cpxFactory.addFactory(new ElementFactoryTextField(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryButton(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryDroplist(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRadioOn(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRadioOff(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOn(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryCheckboxOff(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryImage(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryRetrieveFromDictonnary(source, dictionary));
        cpxFactory.addFactory(new ElementFactoryText(source, dictionary));
    }
}

