/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.ShadowShape;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentBlueModernNote
extends AbstractTextualComponent {
    private final int shadowview = 4;
    private final int cornersize = 10;
    private final HtmlColor back;
    private final HtmlColor foregroundColor;

    public ComponentBlueModernNote(HtmlColor back, HtmlColor foregroundColor, FontConfiguration font, Display strings, ISkinSimple spriteContainer) {
        super(LineBreakStrategy.NONE, strings, font, HorizontalAlignment.LEFT, 6, 15, 5, spriteContainer, false, null, null);
        this.back = back;
        this.foregroundColor = foregroundColor;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPaddingX() {
        return 9.0;
    }

    @Override
    public double getPaddingY() {
        return 9.0;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        double textHeight = this.getTextHeight(stringBounder);
        double textWidth = this.getTextWidth(stringBounder);
        ShadowShape shadowShape = new ShadowShape(textWidth, textHeight, 3.0);
        shadowShape.drawU(ug.apply(new UTranslate(4.0, 4.0)));
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, textHeight);
        polygon.addPoint(textWidth, textHeight);
        polygon.addPoint(textWidth, 10.0);
        polygon.addPoint(textWidth - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        ug = ug.apply(new UChangeBackColor(this.back));
        ug = ug.apply(new UChangeColor(this.foregroundColor));
        ug.draw(polygon);
        ug.apply(new UTranslate(textWidth - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        ug.apply(new UTranslate(textWidth, 10.0)).draw(new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }
}

