/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class PentaBShape
implements UDrawable {
    private final double width;
    private final double height;
    private final SymbolContext context;
    private final double delta = 12.0;

    private PentaBShape(double width, double height, SymbolContext context) {
        this.width = width;
        this.height = height;
        this.context = context;
    }

    public static PentaBShape create(double width, double height, SymbolContext context) {
        return new PentaBShape(width, height, context);
    }

    @Override
    public void drawU(UGraphic ug) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(12.0, 0.0);
        polygon.addPoint(this.width, 0.0);
        polygon.addPoint(this.width, this.height);
        polygon.addPoint(12.0, this.height);
        polygon.addPoint(0.0, this.height / 2.0);
        this.context.withForeColor(this.context.getBackColor()).apply(ug).draw(polygon);
        UPath path2 = new UPath();
        path2.moveTo(this.width, 0.0);
        path2.lineTo(12.0, 0.0);
        path2.lineTo(0.0, this.height / 2.0);
        path2.lineTo(12.0, this.height);
        path2.lineTo(this.width, this.height);
        this.context.apply(ug).draw(path2);
    }
}

