/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DriverPolygonSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UPolygon shape = (UPolygon)ushape;
        double[] points = shape.getPointArray(x, y);
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            for (int j = 0; j < points.length; j += 2) {
                if (clip.isInside(points[j], points[j + 1])) continue;
                return;
            }
        }
        String color = StringUtils.getAsSvg(mapper, param.getColor());
        HtmlColor back = param.getBackcolor();
        if (back instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            String id = svg.createSvgGradient(StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor1())), StringUtils.getAsHtml(mapper.getMappedColor(gr.getColor2())), gr.getPolicy());
            svg.setFillColor("url(#" + id + ")");
        } else {
            String backcolorString = StringUtils.getAsSvg(mapper, back);
            svg.setFillColor(backcolorString);
        }
        svg.setStrokeColor(color);
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        svg.svgPolygon(shape.getDeltaShadow(), points);
    }
}

