/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions;
    private final ConcurrentMap<String, List<T>> myCache;
    @NonNls
    private final String lock;
    private final String myEpName;
    private final List<ExtensionPointListener<T>> myListeners;
    private final ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;

    public KeyedExtensionCollector(final @NonNls @NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this.myExplicitExtensions = new THashMap();
        this.myCache = ContainerUtil.newConcurrentMap();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                if (bean == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = KeyedExtensionCollector.this.lock;
                synchronized (string) {
                    if (bean.getKey() == null) {
                        if (pluginDescriptor != null) {
                            throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                        }
                        LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                        return;
                    }
                    String skey = bean.getKey();
                    KeyedExtensionCollector.this.myCache.remove(skey);
                    for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                        listener.extensionAdded(bean.getInstance(), null);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                if (bean == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = KeyedExtensionCollector.this.lock;
                synchronized (string) {
                    String skey = bean.getKey();
                    KeyedExtensionCollector.this.myCache.remove(skey);
                    for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                        listener.extensionRemoved(bean.getInstance(), null);
                    }
                }
            }

            public void areaReplaced(@NotNull ExtensionsArea area) {
                if (area == null) {
                    1.$$$reportNull$$$0(2);
                }
                KeyedExtensionCollector.this.myCache.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bean";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "area";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaReplaced";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
        Extensions.getRootArea().addAvailabilityListener(epName, new ExtensionPointAvailabilityListener(){

            public void extensionPointRegistered(@NotNull ExtensionPoint extensionPoint) {
                if (extensionPoint == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (extensionPoint.getName().equals(epName)) {
                    extensionPoint.addExtensionPointListener((ExtensionPointListener)KeyedExtensionCollector.this.myListener);
                    KeyedExtensionCollector.this.myCache.clear();
                }
            }

            public void extensionPointRemoved(@NotNull ExtensionPoint extensionPoint) {
                if (extensionPoint == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extensionPoint";
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionPointRegistered";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionPointRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List list = this.myExplicitExtensions.computeIfAbsent(skey, __ -> new SmartList());
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (t == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.myExplicitExtensions.remove(skey);
                }
            }
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        String string = key.toString();
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        Object cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        if ((cached = (ImmutableList)this.myCache.get(stringKey = this.keyToString(key))) == null) {
            List<T> list = this.buildExtensions(stringKey, key);
            cached = list.isEmpty() ? Collections.emptyList() : (list.size() == 1 ? ContainerUtil.immutableSingletonList(list.get(0)) : ContainerUtil.immutableList((Object[])list.toArray()));
            cached = (List)ConcurrencyUtil.cacheOrGet(this.myCache, (Object)stringKey, cached);
        }
        ImmutableList immutableList = cached;
        if (immutableList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        String string = this.lock;
        // MONITORENTER : string
        List<T> list2 = this.myExplicitExtensions.get(stringKey);
        ArrayList<T> arrayList = list2 == null ? null : new ArrayList<T>(list2);
        List<T> list3 = this.buildExtensionsFromExtensionPoint(arrayList, bean -> {
            if (stringKey == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(21);
            }
            return stringKey.equals(bean.getKey());
        });
        List list = list3 == null ? Collections.emptyList() : list3;
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(12);
        return list;
    }

    private List<T> buildExtensionsFromExtensionPoint(@Nullable List<T> result2, @NotNull Predicate<KeyedLazyInstance<T>> isMyBean) {
        ExtensionPoint<KeyedLazyInstance<T>> point;
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(13);
        }
        if ((point = this.getPoint()) != null) {
            KeyedLazyInstance[] beans;
            for (KeyedLazyInstance bean : beans = (KeyedLazyInstance[])point.getExtensions()) {
                Object instance;
                if (!isMyBean.test(bean)) continue;
                try {
                    instance = bean.getInstance();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception | LinkageError e) {
                    LOG.error(e);
                    continue;
                }
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(instance);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final List<T> buildExtensions(@NotNull Set<String> keys) {
        if (keys == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(14);
        }
        String string = this.lock;
        // MONITORENTER : string
        List<T> result2 = null;
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!keys.contains(key)) continue;
            List<T> list2 = entry.getValue();
            if (result2 == null) {
                result2 = new ArrayList<T>(list2);
                continue;
            }
            result2.addAll(list2);
        }
        List list = (result2 = this.buildExtensionsFromExtensionPoint(result2, bean -> {
            if (keys == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(20);
            }
            return keys.contains(bean.getKey());
        })) == null ? Collections.emptyList() : result2;
        // MONITOREXIT : string
        if (list != null) return list;
        KeyedExtensionCollector.$$$reportNull$$$0(15);
        return list;
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().hasExtensionPoint(this.myEpName) ? Extensions.getRootArea().getExtensionPoint(this.myEpName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    public void addListener(@NotNull ExtensionPointListener<T> listener, @NotNull Disposable parent) {
        if (listener == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, () -> {
            if (listener == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(19);
            }
            this.myListeners.remove(listener);
        });
    }

    @NotNull
    public String getName() {
        String string = this.myEpName;
        if (string == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addListener$3";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildExtensions$2";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildExtensions$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

