/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileGroup
implements JDOMExternalizable {
    public String myUpdateName;
    public String myStatusName;
    private final Map<String, String> myErrorsMap = new HashMap<String, String>();
    private final Collection<UpdatedFile> myFiles = new ArrayList<UpdatedFile>();
    public boolean mySupportsDeletion;
    public boolean myCanBeAbsent;
    public String myId;
    @NonNls
    private static final String PATH = "PATH";
    @NonNls
    private static final String VCS_ATTRIBUTE = "vcs";
    @NonNls
    private static final String REVISION_ATTRIBUTE = "revision";
    private final List<FileGroup> myChildren = new ArrayList<FileGroup>();
    @NonNls
    private static final String FILE_GROUP_ELEMENT_NAME = "FILE-GROUP";
    @NonNls
    public static final String MODIFIED_ID = "MODIFIED";
    @NonNls
    public static final String MERGED_WITH_CONFLICT_ID = "MERGED_WITH_CONFLICTS";
    @NonNls
    public static final String MERGED_WITH_TREE_CONFLICT = "MERGED_WITH_TREE_CONFLICT";
    @NonNls
    public static final String MERGED_WITH_PROPERTY_CONFLICT_ID = "MERGED_WITH_PROPERTY_CONFLICT";
    @NonNls
    public static final String MERGED_ID = "MERGED";
    @NonNls
    public static final String UNKNOWN_ID = "UNKNOWN";
    @NonNls
    public static final String LOCALLY_ADDED_ID = "LOCALLY_ADDED";
    @NonNls
    public static final String LOCALLY_REMOVED_ID = "LOCALLY_REMOVED";
    @NonNls
    public static final String UPDATED_ID = "UPDATED";
    @NonNls
    public static final String REMOVED_FROM_REPOSITORY_ID = "REMOVED_FROM_REPOSITORY";
    @NonNls
    public static final String CREATED_ID = "CREATED";
    @NonNls
    public static final String RESTORED_ID = "RESTORED";
    @NonNls
    public static final String CHANGED_ON_SERVER_ID = "CHANGED_ON_SERVER";
    @NonNls
    public static final String SKIPPED_ID = "SKIPPED";
    @NonNls
    public static final String SWITCHED_ID = "SWITCHED";

    public FileGroup(String updateName, String statusName, boolean supportsDeletion, String id, boolean canBeAbsent) {
        this.mySupportsDeletion = supportsDeletion;
        this.myId = id;
        this.myCanBeAbsent = canBeAbsent;
        this.myUpdateName = updateName;
        this.myStatusName = statusName;
    }

    public FileGroup() {
    }

    public void addChild(FileGroup child) {
        this.myChildren.add(child);
    }

    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void addError(@NotNull String path2, @NotNull String error) {
        if (path2 == null) {
            FileGroup.$$$reportNull$$$0(0);
        }
        if (error == null) {
            FileGroup.$$$reportNull$$$0(1);
        }
        this.myErrorsMap.put(path2, error);
    }

    @NotNull
    public Map<String, String> getErrorsMap() {
        Map<String, String> map = this.myErrorsMap;
        if (map == null) {
            FileGroup.$$$reportNull$$$0(2);
        }
        return map;
    }

    public void add(@NotNull String path2, @NotNull String vcsName, @Nullable VcsRevisionNumber revision) {
        if (path2 == null) {
            FileGroup.$$$reportNull$$$0(3);
        }
        if (vcsName == null) {
            FileGroup.$$$reportNull$$$0(4);
        }
        this.myFiles.add(new UpdatedFile(path2, vcsName, revision == null ? "" : revision.asString()));
    }

    public void add(@NotNull String path2, @NotNull VcsKey vcsKey, @Nullable VcsRevisionNumber revision) {
        if (path2 == null) {
            FileGroup.$$$reportNull$$$0(5);
        }
        if (vcsKey == null) {
            FileGroup.$$$reportNull$$$0(6);
        }
        this.myFiles.add(new UpdatedFile(path2, vcsKey, revision == null ? "" : revision.asString()));
    }

    public void remove(String path2) {
        for (UpdatedFile file : this.myFiles) {
            if (!file.getPath().equals(path2)) continue;
            this.myFiles.remove(file);
            break;
        }
    }

    public int getImmediateFilesSize() {
        return this.myFiles.size();
    }

    public Collection<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (UpdatedFile file : this.myFiles) {
            files.add(file.getPath());
        }
        return files;
    }

    public Collection<UpdatedFile> getUpdatedFiles() {
        return new ArrayList<UpdatedFile>(this.myFiles);
    }

    public List<Pair<String, VcsRevisionNumber>> getFilesAndRevisions(ProjectLevelVcsManager vcsManager) {
        ArrayList<Pair<String, VcsRevisionNumber>> files = new ArrayList<Pair<String, VcsRevisionNumber>>();
        for (UpdatedFile file : this.myFiles) {
            VcsRevisionNumber number = FileGroup.getRevision(vcsManager, file);
            files.add((Pair<String, VcsRevisionNumber>)Pair.create((Object)file.getPath(), (Object)number));
        }
        return files;
    }

    public boolean isEmpty() {
        if (!this.myFiles.isEmpty()) {
            return false;
        }
        for (FileGroup child : this.myChildren) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public SimpleTextAttributes getInvalidAttributes() {
        if (this.myCanBeAbsent) {
            return new SimpleTextAttributes(0, FileStatus.DELETED.getColor());
        }
        return SimpleTextAttributes.ERROR_ATTRIBUTES;
    }

    public String getId() {
        return this.myId;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (UpdatedFile file : this.myFiles) {
            Element path2 = new Element(PATH);
            path2.setText(file.getPath());
            if (file.getVcsName() != null) {
                path2.setAttribute(VCS_ATTRIBUTE, file.getVcsName());
            }
            if (file.getRevision() != null) {
                path2.setAttribute(REVISION_ATTRIBUTE, file.getRevision());
            }
            element.addContent(path2);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        List pathElements = element.getChildren(PATH);
        for (Object pathElement1 : pathElements) {
            Element pathElement = (Element)pathElement1;
            String path2 = pathElement.getText();
            String vcsName = pathElement.getAttributeValue(VCS_ATTRIBUTE);
            String revision = pathElement.getAttributeValue(REVISION_ATTRIBUTE);
            if (vcsName == null) continue;
            this.myFiles.add(new UpdatedFile(path2, vcsName, revision));
        }
    }

    public List<FileGroup> getChildren() {
        return this.myChildren;
    }

    public static void writeGroupsToElement(List<FileGroup> groups, Element element) throws WriteExternalException {
        for (FileGroup fileGroup : groups) {
            Element groupElement = new Element(FILE_GROUP_ELEMENT_NAME);
            element.addContent(groupElement);
            fileGroup.writeExternal(groupElement);
            FileGroup.writeGroupsToElement(fileGroup.getChildren(), groupElement);
        }
    }

    public static void readGroupsFromElement(List<FileGroup> groups, Element element) throws InvalidDataException {
        List groupElements = element.getChildren();
        for (Object groupElement1 : groupElements) {
            Element groupElement = (Element)groupElement1;
            FileGroup fileGroup = new FileGroup();
            fileGroup.readExternal(groupElement);
            groups.add(fileGroup);
            FileGroup.readGroupsFromElement(fileGroup.myChildren, groupElement);
        }
    }

    public String getStatusName() {
        return this.myStatusName;
    }

    public String getUpdateName() {
        return this.myUpdateName;
    }

    public String toString() {
        return this.myId + " " + this.myFiles.size() + " items: " + this.myFiles;
    }

    @Nullable
    public VcsRevisionNumber getRevision(ProjectLevelVcsManager vcsManager, String path2) {
        for (UpdatedFile file : this.myFiles) {
            if (!file.getPath().equals(path2)) continue;
            return FileGroup.getRevision(vcsManager, file);
        }
        return null;
    }

    @Nullable
    private static VcsRevisionNumber getRevision(ProjectLevelVcsManager vcsManager, UpdatedFile file) {
        AbstractVcs vcs;
        String vcsName = file.getVcsName();
        String revision = file.getRevision();
        if (vcsName != null && revision != null && (vcs = vcsManager.findVcsByName(vcsName)) != null) {
            try {
                return vcs.parseRevisionNumber(revision, VcsUtil.getFilePath(file.getPath()));
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/FileGroup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/FileGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class UpdatedFile {
        private final String myPath;
        private final String myVcsName;
        private final String myRevision;

        public UpdatedFile(String path2, @NotNull VcsKey vcsKey, String revision) {
            if (vcsKey == null) {
                UpdatedFile.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
            this.myVcsName = vcsKey.getName();
            this.myRevision = revision;
        }

        private UpdatedFile(String path2, @NotNull String vcsName, String revision) {
            if (vcsName == null) {
                UpdatedFile.$$$reportNull$$$0(1);
            }
            this.myPath = path2;
            this.myVcsName = vcsName;
            this.myRevision = revision;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getVcsName() {
            return this.myVcsName;
        }

        public String getRevision() {
            return this.myRevision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcsKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcsName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/update/FileGroup$UpdatedFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

