/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nullable;

public class PsiNavigateUtil {
    public static void navigate(@Nullable PsiElement psiElement) {
        if (psiElement != null && psiElement.isValid()) {
            PsiElement navigationElement = psiElement.getNavigationElement();
            int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiElement);
            if (virtualFile2 != null && virtualFile2.isValid()) {
                new OpenFileDescriptor(navigationElement.getProject(), virtualFile2, offset).navigate(true);
            } else if (navigationElement instanceof Navigatable) {
                ((Navigatable)((Object)navigationElement)).navigate(true);
            }
        }
    }
}

