/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.SmartFMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.JavaMethodSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JavaMethod
implements AnnotatedElement {
    public static final JavaMethod[] EMPTY_ARRAY = new JavaMethod[0];
    private static final Object NONE = new Object();
    private final JavaMethodSignature mySignature;
    private final Class myDeclaringClass;
    private final Method myMethod;
    private volatile SmartFMap<Class, Object> myAnnotationsMap = SmartFMap.emptyMap();

    private JavaMethod(Class declaringClass, JavaMethodSignature signature) {
        this.mySignature = signature;
        this.myMethod = signature.findMethod(declaringClass);
        assert (this.myMethod != null) : "No method " + signature + " in class " + declaringClass;
        this.myDeclaringClass = this.myMethod.getDeclaringClass();
    }

    public final Class getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public final JavaMethodSignature getSignature() {
        return this.mySignature;
    }

    public final List<Method> getHierarchy() {
        return this.mySignature.getAllMethods(this.myDeclaringClass);
    }

    public String getMethodName() {
        return this.mySignature.getMethodName();
    }

    public final Method getMethod() {
        return this.myMethod;
    }

    public final Type[] getGenericParameterTypes() {
        return this.myMethod.getGenericParameterTypes();
    }

    public final Type getGenericReturnType() {
        return this.myMethod.getGenericReturnType();
    }

    public static JavaMethod getMethod(Class declaringClass, JavaMethodSignature signature) {
        return new JavaMethod(declaringClass, signature);
    }

    public static JavaMethod getMethod(Class declaringClass, Method method) {
        return JavaMethod.getMethod(declaringClass, new JavaMethodSignature(method));
    }

    public final Object invoke(Object o, Object ... args) {
        return DomReflectionUtil.invokeMethod(this.myMethod, o, args);
    }

    public String toString() {
        return "JavaMethod: " + this.myMethod.toString();
    }

    @NonNls
    public final String getName() {
        return this.myMethod.getName();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Object annotation = this.myAnnotationsMap.get(annotationClass);
        if (annotation == null) {
            annotation = this.findAnnotation(annotationClass);
            this.myAnnotationsMap = this.myAnnotationsMap.plus(annotationClass, annotation);
        }
        return (T)(annotation == NONE ? null : (Annotation)annotation);
    }

    @NotNull
    private Object findAnnotation(Class<? extends Annotation> annotationClass) {
        Annotation annotation = this.mySignature.findAnnotation(annotationClass, this.myDeclaringClass);
        Object object = annotation == null ? NONE : annotation;
        if (object == null) {
            JavaMethod.$$$reportNull$$$0(0);
        }
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethod)) {
            return false;
        }
        JavaMethod that = (JavaMethod)o;
        if (!this.myDeclaringClass.equals(that.myDeclaringClass)) {
            return false;
        }
        return this.mySignature.equals(that.mySignature);
    }

    public int hashCode() {
        int result2 = this.mySignature.hashCode();
        result2 = 31 * result2 + this.myDeclaringClass.hashCode();
        return result2;
    }

    public final Class getReturnType() {
        return this.myMethod.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.myMethod.getParameterTypes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/JavaMethod", "findAnnotation"));
    }
}

